# Project Requirements

## Project

**Name**: Restaurant Management System

**Version**: 1.0.0

**Laravel version**: 10.49.0

**Php required**: ^8.1

**Database**: MySQL 8.0+ / MariaDB 10.4+

## Server requirements

### Php extensions
- bcmath
- ctype
- curl
- dom
- fileinfo
- json
- mbstring
- openssl
- pdo
- tokenizer
- xml

**Php version**: 8.1+

**Database**: MySQL 8.0+ or MariaDB 10.4+

**Web server**: Apache/Nginx

**Composer**: 2.0+

## Installation steps

**0**: 1. Clone repository

**1**: 2. Run: composer install

**2**: 3. Copy .env.example to .env

**3**: 4. Set database credentials in .env

**4**: 5. Run: php artisan key:generate

**5**: 6. Run: php artisan migrate --seed

**6**: 7. Run: php artisan storage:link

## Migration commands

**Fresh install**: php artisan migrate:fresh --seed

**Standard migration**: php artisan migrate

**Rollback**: php artisan migrate:rollback

**Seed only**: php artisan db:seed

**Import sql dump**: php artisan db:seed --class=ImportSqlDumpSeeder

## Default users

**Admin**: Full system administrator

**Denis**: Cashier - sales verification

**Beatrice**: Waiter - order management

**Asha**: Waiter - order management

## Important notes

**0**: Change default passwords after first login

**1**: Set APP_ENV=production for live deployment

**2**: Configure QUEUE_CONNECTION for background jobs

**3**: Set proper file permissions for storage

**4**: Regularly backup database

