<?php

namespace App\Exports;

use App\Models\Sale;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Http\Request;

class SalesExport implements FromCollection, WithHeadings
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = Sale::with(['waiter','cashier','items.product']);

        if ($this->request->filled('from') && $this->request->filled('to')) {
            $query->whereBetween('created_at', [$this->request->from.' 00:00:00', $this->request->to.' 23:59:59']);
        }
        if ($this->request->filled('waiter_id'))    $query->where('waiter_id', $this->request->waiter_id);
        if ($this->request->filled('cashier_id'))   $query->where('cashier_id', $this->request->cashier_id);
        if ($this->request->filled('payment_type')) $query->where('payment_type', $this->request->payment_type);
        if ($this->request->filled('status'))       $query->where('status', $this->request->status);

        return $query->get()->map(function($sale){
            return [
                'Date'     => $sale->created_at->format('d-m-Y H:i'),
                'Waiter'   => $sale->waiter?->name ?? '—',
                'Cashier'  => $sale->cashier?->name ?? '—',
                'Subtotal' => $sale->subtotal,
                'Tax'      => $sale->tax,
                'Total'    => $sale->total,
                'Payment'  => $sale->payment_type,
                'Status'   => $sale->status,
            ];
        });
    }

    public function headings(): array
    {
        return ['Date','Waiter','Cashier','Subtotal','Tax','Total','Payment','Status'];
    }
}
