<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;
use Auth;

class ProductController extends Controller
{
    public function index()
    {
        $categories = Category::all(); // needed for assigning during product creation
        return view('product.list', compact('categories'));
    }

    public function data()
    {
        $products = Product::with('category')->latest()->get();
        return response()->json($products);
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_name'   => 'required|string|max:255',
            'category_id'    => 'nullable|exists:categories,id',
            'purchase_price' => 'required|numeric|min:0',
            'selling_price'  => 'required|numeric|min:0',
            'stock'          => 'required|integer|min:0',
        ]);

        $product = Product::create($request->all());
        $product->load('category'); 
        return response()->json($product);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'product_name'   => 'required|string|max:255',
            'category_id'    => 'nullable|exists:categories,id',
            'purchase_price' => 'required|numeric|min:0',
            'selling_price'  => 'required|numeric|min:0',
            'stock'          => 'required|integer|min:0',
        ]);

        $product = Product::findOrFail($id);
        $product->update($request->all());
        $product->load('category');

        return response()->json($product);
    }

    public function destroy($id)
    {
        $product = Product::findOrFail($id);
        $productName = $product->product_name;
        $product->delete();

        return response()->json(['success' => true, 'product_name' => $productName]);
    }
}
