<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Model\Factories\HasFactory;
use Request;



class Category extends Model
{
    protected $fillable = ['category_name'];


    /**
     * Category belongs to a Store
     */
    public function store()
    {
        return $this->belongsTo(Store::class, 'store_id');
    }

    /**
     * Category has many Products
     */
        public function products()
        {
            return $this->hasMany(Product::class); // read-only, products not controlled by category
        }

}
