<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Sale extends Model
{
    protected $fillable = [
        'waiter_id',
        'cashier_id',
        'payment_type',
        'subtotal',
        'tax',
        'total',
        'status',

    ];

    protected $casts = [
        'verified_at' => 'datetime',
    ];

    public function items()
    {
        return $this->hasMany(SaleItem::class);
    }

    public function waiter()
    {
        return $this->belongsTo(User::class, 'waiter_id');
    }

    public function cashier()
    {
        return $this->belongsTo(User::class, 'cashier_id');
    }

    /**
     * Get cashier name with fallback for pending verification
     */
    public function getCashierNameAttribute()
    {
        return $this->cashier ? $this->cashier->name : '-';
    }

    /**
     * Check if sale is verified
     */
    public function getIsVerifiedAttribute()
    {
        return $this->status === 'verified';
    }

    /**
     * Scope for pending sales
     */
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    /**
     * Scope for verified sales
     */
    public function scopeVerified($query)
    {
        return $query->where('status', 'verified');
    }
}