<?php

namespace App\Services;

use App\Models\Sale;
use Illuminate\Http\Request;
use Carbon\Carbon;

class SalesChartService
{
    public function getYesterdayTodayComparison(Request $request = null)
    {
        $today = Carbon::today();
        $yesterday = Carbon::yesterday();
        
        $todaySales = $this->getHourlySalesForDate($today, $request);
        $yesterdaySales = $this->getHourlySalesForDate($yesterday, $request);
        
        return [
            'today_sales' => $todaySales['hourly_sales'],
            'yesterday_sales' => $yesterdaySales['hourly_sales'],
            'today_orders' => $todaySales['hourly_orders'],
            'yesterday_orders' => $yesterdaySales['hourly_orders'],
            'today_date' => $today->format('Y-m-d'),
            'yesterday_date' => $yesterday->format('Y-m-d'),
            'time_labels' => $this->generateTimeLabels()
        ];
    }
    
    // ADD THIS METHOD if you need single date data elsewhere
    public function getHourlySalesData(Request $request = null, $date = null)
    {
        $date = $date ? Carbon::parse($date) : Carbon::today();
        $data = $this->getHourlySalesForDate($date, $request);
        
        return array_merge($data, [
            'date' => $date->format('Y-m-d'),
            'time_labels' => $this->generateTimeLabels()
        ]);
    }
    
    private function getHourlySalesForDate($date, $request = null)
    {
        // Initialize arrays for 7:00 to 22:00 (16 hours)
        $hourlySales = array_fill(0, 16, 0);
        $hourlyOrders = array_fill(0, 16, 0);
        
        $query = Sale::whereDate('created_at', $date);
        
        if ($request) {
            if ($request->filled('waiter_id')) {
                $query->where('waiter_id', $request->waiter_id);
            }
            
            if ($request->filled('cashier_id')) {
                $query->where('cashier_id', $request->cashier_id);
            }
            
            if ($request->filled('payment_type')) {
                $query->where('payment_type', $request->payment_type);
            }
            
            if ($request->filled('status')) {
                $query->where('status', $request->status);
            }
        }
        
        $sales = $query->get();
        
        foreach ($sales as $sale) {
            $hour = $sale->created_at->hour;
            if ($hour >= 7 && $hour <= 22) {
                $index = $hour - 7;
                $hourlySales[$index] += $sale->total;
                $hourlyOrders[$index] += 1;
            }
        }
        
        return [
            'hourly_sales' => $hourlySales,
            'hourly_orders' => $hourlyOrders
        ];
    }
    
    private function generateTimeLabels()
    {
        $labels = [];
        for ($hour = 7; $hour <= 22; $hour++) {
            $labels[] = sprintf('%02d:00', $hour);
        }
        return $labels;
    }
}