<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('username', 100);
            $table->string('email')->nullable();
            $table->integer('status')->nullable()->default(1)->comment('1:active, 0:inactive');
            $table->string('password')->nullable();
            $table->rememberToken();
            $table->tinyInteger('is_role')->default(3)->comment('1:Admin, 2:Cashier, 3:Waiter');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
