<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->BigIncrements('id');
            $table->unsignedBigInteger('waiter_id')->index('fk_sales_waiter');
            $table->unsignedBigInteger('cashier_id')->nullable()->index('fk_sales_cashier');
            $table->enum('status', ['pending', 'verified'])->default('pending');
            $table->string('payment_type', 11)->default('0');
            $table->string('subtotal')->default('0');
            $table->string('tax')->default('0');
            $table->decimal('total', 12);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
