<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->foreign(['cashier_id'], 'fk_sales_cashier')->references(['id'])->on('users')->onUpdate('restrict')->onDelete('set null');
            $table->foreign(['waiter_id'], 'fk_sales_waiter')->references(['id'])->on('users')->onUpdate('restrict')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropForeign('fk_sales_cashier');
            $table->dropForeign('fk_sales_waiter');
        });
    }
};
