<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('stocktakings', function (Blueprint $table) {
            $table->BigIncrements('id');
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->date('date');
            $table->integer('opening_stock')->default(0);
            $table->integer('additional_stock')->default(0);
            $table->decimal('buying_price', 10, 2)->default(0);
            $table->decimal('selling_price', 10, 2)->default(0);
            $table->integer('sold_quantity')->default(0);
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();

            $table->unique(['product_id', 'date']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('stocktakings');
    }
};