-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Oct 06, 2025 at 10:00 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `restaurant`
--
CREATE DATABASE IF NOT EXISTS `stephen_restaurant` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `stephen_restaurant`;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE IF NOT EXISTS `categories` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `category_name`, `created_at`, `updated_at`) VALUES
(1, 'Lunch', '2025-09-24 10:24:17', '2025-09-30 16:11:32'),
(2, 'breakfast', '2025-09-24 10:24:17', '2025-09-24 10:25:34'),
(41, 'barbeque', '2025-09-25 05:38:20', '2025-09-25 05:38:20'),
(43, 'drinks', '2025-09-25 12:19:17', '2025-09-25 12:19:17'),
(44, 'desserts', '2025-09-29 10:14:37', '2025-09-29 10:14:37'),
(45, 'specials', '2025-09-29 19:29:05', '2025-09-29 19:29:05');

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE IF NOT EXISTS `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE IF NOT EXISTS `products` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) UNSIGNED DEFAULT NULL,
  `product_name` varchar(255) DEFAULT NULL,
  `stock` varchar(255) NOT NULL DEFAULT '0',
  `purchase_price` varchar(255) NOT NULL DEFAULT '0',
  `selling_price` varchar(255) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_category_id_foreign` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `category_id`, `product_name`, `stock`, `purchase_price`, `selling_price`, `created_at`, `updated_at`) VALUES
(2, 1, 'wali kuku', '5', '7000', '11000', '2025-09-25 05:45:46', '2025-09-25 12:29:40'),
(3, 1, 'makange kuku', '6', '10000', '14000', '2025-09-25 12:18:09', '2025-09-25 12:18:09'),
(4, 2, 'andazi', '7', '600', '1000', '2025-09-25 12:18:45', '2025-09-29 19:26:48'),
(6, 2, 'chapati', '34', '1000', '2000', '2025-09-25 12:23:41', '2025-09-25 12:23:41'),
(7, 2, 'kalimati', '23', '300', '500', '2025-09-25 12:26:53', '2025-09-25 12:26:53'),
(8, 1, 'ugali samaki', '12', '8000', '15000', '2025-09-25 12:27:45', '2025-09-25 12:27:45'),
(9, 1, 'wali nyama', '43', '10000', '14000', '2025-09-25 12:33:44', '2025-09-25 12:33:44'),
(10, 1, 'ugali maharage', '12', '4000', '6000', '2025-09-26 16:27:19', '2025-09-26 16:27:19'),
(11, 41, 'foil mbuzi', '23', '7000', '10000', '2025-09-29 10:16:21', '2025-09-29 10:16:21'),
(12, 2, 'egg chop', '23', '1000', '2000', '2025-09-29 19:27:29', '2025-09-29 19:27:29');

-- --------------------------------------------------------

--
-- Table structure for table `sales`
--

CREATE TABLE IF NOT EXISTS `sales` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `waiter_id` bigint(20) UNSIGNED NOT NULL,
  `cashier_id` bigint(20) UNSIGNED DEFAULT NULL,
  `status` enum('pending','verified') NOT NULL DEFAULT 'pending',
  `payment_type` varchar(11) NOT NULL DEFAULT '0',
  `subtotal` varchar(255) NOT NULL DEFAULT '0',
  `tax` varchar(255) NOT NULL DEFAULT '0',
  `total` decimal(12,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_sales_waiter` (`waiter_id`),
  KEY `fk_sales_cashier` (`cashier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sales`
--

INSERT INTO `sales` (`id`, `waiter_id`, `cashier_id`, `status`, `payment_type`, `subtotal`, `tax`, `total`, `created_at`, `updated_at`) VALUES
(1, 4, 1, 'verified', 'Cash', '12300', '2700', 15000.00, '2025-09-26 03:31:54', '2025-09-26 03:31:54'),
(2, 4, 11, 'verified', 'Cash', '3280', '720', 4000.00, '2025-09-26 04:51:05', '2025-10-03 08:59:50'),
(3, 3, 11, 'verified', 'Cash', '12300', '2700', 15000.00, '2025-09-26 04:55:15', '2025-10-03 08:59:57'),
(4, 3, 11, 'verified', 'Cash', '24600', '5400', 30000.00, '2025-09-26 05:02:20', '2025-10-03 09:00:04'),
(5, 3, 11, 'verified', 'Cash', '24600', '5400', 30000.00, '2025-09-26 05:13:52', '2025-10-03 09:00:09'),
(6, 3, 11, 'verified', 'Cash', '24600', '5400', 30000.00, '2025-09-26 05:18:18', '2025-10-03 09:00:16'),
(7, 3, 1, 'verified', 'Cash', '37720', '8280', 46000.00, '2025-09-26 05:19:36', '2025-09-26 05:19:36'),
(8, 3, 1, 'verified', 'Cash', '33620', '7380', 41000.00, '2025-09-26 05:19:56', '2025-09-26 05:19:56'),
(9, 3, 11, 'verified', 'Cash', '820', '180', 1000.00, '2025-09-26 07:04:24', '2025-10-03 09:00:21'),
(10, 3, 11, 'verified', 'Cash', '820', '180', 1000.00, '2025-09-26 07:14:36', '2025-10-03 09:00:24');

-- --------------------------------------------------------

--
-- Table structure for table `sale_items`
--

CREATE TABLE IF NOT EXISTS `sale_items` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sale_id` bigint(20) UNSIGNED NOT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `price` decimal(12,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_sale_items_sale` (`sale_id`),
  KEY `sale_items_product_id_foreign` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sale_items`
--

INSERT INTO `sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `price`, `created_at`, `updated_at`) VALUES
(1, 1, 4, 1, 1000.00, '2025-09-26 03:31:54', '2025-09-26 03:31:54'),
(2, 1, 3, 1, 14000.00, '2025-09-26 03:31:54', '2025-09-26 03:31:54'),
(3, 2, 7, 1, 500.00, '2025-09-26 04:51:05', '2025-09-26 04:51:05'),
(4, 2, 4, 2, 1000.00, '2025-09-26 04:51:05', '2025-09-26 04:51:05'),
(6, 3, 3, 1, 14000.00, '2025-09-26 04:55:15', '2025-09-26 04:55:15'),
(7, 3, 4, 1, 1000.00, '2025-09-26 04:55:15', '2025-09-26 04:55:15'),
(8, 4, 3, 2, 14000.00, '2025-09-26 05:02:20', '2025-09-26 05:02:20'),
(9, 4, 4, 2, 1000.00, '2025-09-26 05:02:20', '2025-09-26 05:02:20'),
(10, 5, 3, 2, 14000.00, '2025-09-26 05:13:52', '2025-09-26 05:13:52'),
(11, 5, 4, 2, 1000.00, '2025-09-26 05:13:52', '2025-09-26 05:13:52');

-- --------------------------------------------------------

--
-- Table structure for table `stocktakings`
--

CREATE TABLE IF NOT EXISTS `stocktakings` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `date` date NOT NULL,
  `opening_stock` int(11) NOT NULL DEFAULT 0,
  `additional_stock` int(11) NOT NULL DEFAULT 0,
  `buying_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `selling_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `sold_quantity` int(11) NOT NULL DEFAULT 0,
  `created_by` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stocktakings_product_id_date_unique` (`product_id`,`date`),
  KEY `stocktakings_date_index` (`date`),
  KEY `stocktakings_product_id_index` (`product_id`),
  KEY `stocktakings_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `stocktakings`
--

INSERT INTO `stocktakings` (`id`, `product_id`, `date`, `opening_stock`, `additional_stock`, `buying_price`, `selling_price`, `sold_quantity`, `created_by`, `created_at`, `updated_at`) VALUES
(2, 2, '2025-09-30', 50, 0, 7000.00, 11000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:27'),
(3, 3, '2025-09-30', 30, 0, 10000.00, 14000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:28'),
(4, 4, '2025-09-30', 70, 0, 600.00, 1000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:28'),
(5, 6, '2025-09-30', 68, 0, 1000.00, 2000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:28'),
(6, 7, '2025-09-30', 50, 0, 300.00, 500.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:28'),
(7, 8, '2025-09-30', 20, 0, 8000.00, 15000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:29'),
(8, 9, '2025-09-30', 37, 0, 10000.00, 14000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:29'),
(9, 10, '2025-09-30', 25, 0, 4000.00, 6000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:29'),
(10, 11, '2025-09-30', 34, 0, 7000.00, 10000.00, 0, 1, '2025-09-30 03:48:05', '2025-09-30 04:22:29');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `username` varchar(100) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `status` int(1) DEFAULT 1 COMMENT '1:active, 0:inactive',
  `password` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `is_role` tinyint(4) NOT NULL DEFAULT 3 COMMENT '1:Admin, 2:Cashier, 3:Waiter',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `username`, `email`, `status`, `password`, `remember_token`, `is_role`, `created_at`, `updated_at`) VALUES
(1, 'Admin', 'admin', 'Admin@gmail.com', 1, '$2y$12$L3a/ySTO2WTwM0wBhVpeG.S4V/8GUCzIBqLis4yRYjwT4Atc/Sa5i', 'lU3euAlRNTEFts1Dof6Wf6oVBBK1tKfxlgEu0Y1CkT1m1dOAx1OH8mcr11JT', 1, '2025-09-22 08:32:27', NULL),
(2, 'denis', 'denis', 'denis@gmail.com', 1, '$2y$12$yXew7LPUDM6FrvzzV5F6H.kr95zzIMWfGNz0f06snwe8H7rz6oCkK', 'eqGWAUDLT7JGoZneDhL8W9H8Y0ukqyZJ1oSJ9OZiKn0eFNvoOaf8QX4tTTys', 2, '2025-09-22 08:32:27', '2025-10-01 07:03:05'),
(3, 'beatrice emmanuel', 'beatrice', 'beatrice@gmail.com', 1, '$2y$12$hZBqT87JMXiJExaaXcOhPepDPGhlIomfXyv./gd.ZMJ642DkZaUNa', '12$L3a/0wBhVpeG.S4V/8GUCzIBqLis4yRYjwT4Atc/Sa5ikGJV', 3, '2025-09-22 08:32:29', '2025-10-01 07:01:05'),
(4, 'aisha juma', 'asha', 'asha@gmail.com', 1, '$2y$12$eI60gFDf.TSAwE/LfKKMTOkHKpK3zfNtXcfl5bNFiUu2iVay2VW0W', 'aZcGZx1x2fhFb1iKtpaEZxTtOBwiS0w5h609XqWWpDoUgzptlKy7TPbnYNNG', 3, '2025-09-22 08:32:29', '2025-09-29 07:16:53'),
(5, 'gift jeremiah', 'gift', 'gift@gmail.com', 0, '$2y$12$XCJZ7vHqQ4HbjNGgQVBZC.QmvZCrESNVk6NOaTiJUcHK/Bh3gC69i', NULL, 3, '2025-09-29 10:32:31', '2025-10-03 04:52:22'),
(6, 'sophie', 'sophie', 'sophia@gmail.com', 1, '$2y$12$wNWSO37XVOGsjUy9RtfkAOjfehtfIYsbf96JMCAaOK.YNyarWrOdG', 'J5ts3mWUhzvTZJk0TqEN7ABrSsjOPqk9AjnUrP95G9BhsyMgrfI6FJaMIjRn', 3, '2025-09-29 10:35:49', '2025-10-01 06:59:47'),
(9, 'teodosia toss', 'teodosia', 'teodosia@gmail', 1, '$2y$12$F5OVV5E34c.cBdLPx5r7o.TmWdu3fYe0aZrcZTQzJiKf.7Olh7bCa', 'xjjGP2VXdrYmBEpUfvLVUKoA22Nr19jDOXNfHeK0YZ25j09MmbXNbSDjcp8b', 3, '2025-10-01 07:04:34', '2025-10-01 07:04:34'),
(10, 'naomy ramadhan', 'naomy', 'naomi@gmail.com', 1, '$2y$12$rMP7QZLiGZkxd17IC30GfuxmL05DdTBrtFCCEWX0QsWq5o5L.tbye', 'CIOhiKhvIqL6TYsttUDD3K6lVZmg8ziQSvnEsnT4hc3fujG7DF4x2e1NYExY', 3, '2025-10-02 06:39:54', '2025-10-02 06:39:54'),
(11, 'violeth isaya', 'violeth', 'violeth@gmail.com', 1, '$2y$12$D8sihmyke8MwFCEQxevFD.b4leTri1yMnfQUBAFfWHYWcmQGo/Bk6', 'Z9JDCTieopKUbWt5CDySjQ6UhWCmPVlkdeGrRExJHyNezX9iK60ratCOAe3h', 2, '2025-10-02 06:54:47', '2025-10-02 06:54:47'),
(12, 'tumaini george', 'tumaini', 'tumaini@gmail.com', 1, '$2y$12$wS3IaFjFl2/u6UgAdUpVLutGIChxIsbHlyn2TyJy6/NwRaxMB2PA6', 'M6DDV5Miw5kBzkNkPMviy60aIH07Et930J70Ag7awXOoKfEQv6l2XClKnAGk', 3, '2025-10-02 07:03:49', '2025-10-02 07:03:49');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `sales`
--
ALTER TABLE `sales`
  ADD CONSTRAINT `fk_sales_cashier` FOREIGN KEY (`cashier_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_sales_waiter` FOREIGN KEY (`waiter_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `sale_items`
--
ALTER TABLE `sale_items`
  ADD CONSTRAINT `fk_sale_items_product` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_sale_items_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sale_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `stocktakings`
--
ALTER TABLE `stocktakings`
  ADD CONSTRAINT `stocktakings_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stocktakings_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;