<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payroll Report Week {{ $week }} from {{ $weekStart->format('j M') }} to {{ $weekEnd->format('j M') }} {{ $year }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header .subtitle {
            color: #666;
            font-size: 14px;
        }
        .summary-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 8px 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .total-row {
            background-color: #e9ecef;
            font-weight: bold;
        }
        .grand-total-row {
            background-color: #343a40;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }
        .eligible {
            color: #28a745;
            font-weight: bold;
        }
        .not-eligible {
            color: #6c757d;
        }
        .special-payment {
            color: #17a2b8;
            font-weight: bold;
            font-style: italic;
        }
        .monthly-salary {
            color: #6f42c1;
            font-weight: bold;
            font-style: italic;
        }
        .section-title {
            background-color: #343a40;
            color: white;
            padding: 10px;
            margin: 20px 0 10px 0;
            font-size: 16px;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            color: #0a0a0aff;
            font-size: 10px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .policy-note {
            background: #fff3cd;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
            border-left: 4px solid #ffc107;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>RESTAURANT WAITERS' PAYROLL REPORT</h1>
        <div class="subtitle">
            Week {{ $week }} of {{ $year }} ({{ $weekStart->format('M j, Y') }} - {{ $weekEnd->format('M j, Y') }})
        </div>
        <div class="subtitle">Generated on: {{ $exportTime }}</div>
    </div>

    <div class="summary-info">
        <strong>Standard Payroll Policy:</strong> 4% of <strong>daily</strong> sales, rounded to the nearest 1,000 TZS  
        (Minimum 100,000 TZS daily sales required).  
        Weekly payment = <strong>sum of daily payments</strong>.
        
        <div class="policy-note">
            <strong>Special Arrangements:</strong><br>
            • <strong>Aisha Juma:</strong> Fixed 10,000 TZS per day worked<br>
            • <strong>Tumaini George:</strong> Paid fixed monthly salary (excluded from weekly payroll)
        </div>
    </div>

    <!-- Weekly Summary -->
    <div class="section-title">WEEKLY PAYROLL SUMMARY</div>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Waiter Name</th>
                <th>Total Weekly Sales (TZS)</th>
                <th>Weekly Payment (TZS)</th>
                <th>Eligible Days</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalWeeklyPayment = 0;
            @endphp
            @foreach($waiters as $index => $waiter)
            @php
                $eligibleDays = count(array_filter($waiter['daily'], fn($day) => $day['is_eligible']));
                $isAisha = strtolower($waiter['name']) === 'aisha juma';
                $isTumaini = strtolower($waiter['name']) === 'tumaini george';
                
                // Add to total only if not Tumaini (monthly salary)
                if (!$isTumaini) {
                    $totalWeeklyPayment += $waiter['weekly_total_payment'];
                }
            @endphp
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $waiter['name'] }}</td>
                <td style="text-align:right;">{{ number_format($waiter['weekly_total_sales'], 0) }}</td>
                <td style="text-align:right;" class="{{ $isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : ($waiter['weekly_total_payment'] > 0 ? 'eligible' : 'not-eligible')) }}">
                    @if($isAisha)
                        {{ number_format($waiter['weekly_total_payment'], 0) }}
                    @elseif($isTumaini)
                        PAID MONTHLY
                    @else
                        {{ number_format($waiter['weekly_total_payment'], 0) }}
                    @endif
                </td>
                <td style="text-align:center;">
                    @if($isAisha)
                        {{ $waiter['days_worked'] ?? 0 }}
                    @else
                        {{ $eligibleDays }}
                    @endif
                </td>
                <td style="text-align:center;">
                    @if($isAisha)
                        <span style="color: #17a2b8;">FIXED DAILY</span>
                    @elseif($isTumaini)
                        <span style="color: #6f42c1;">MONTHLY SALARY</span>
                    @else
                        {{ $waiter['weekly_total_payment'] > 0 ? 'PAYABLE' : 'NO PAYMENT' }}
                    @endif
                </td>
            </tr>
            @endforeach
            
            <!-- Total Row -->
            <tr class="grand-total-row">
                <td colspan="3" style="text-align: right;"><strong>TOTAL WEEKLY PAYMENT:</strong></td>
                <td style="text-align:right; color: white;">
                    <strong>{{ number_format($totalWeeklyPayment, 0) }} TZS</strong>
                </td>
                <td colspan="2" style="text-align: center; color: white;">
                    <strong>AMOUNT TO BE PAID</strong>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Daily Breakdown -->
    @foreach($waiters as $waiter)
    @php
        $isAisha = strtolower($waiter['name']) === 'aisha juma';
        $isTumaini = strtolower($waiter['name']) === 'tumaini george';
    @endphp
    
    <div class="section-title">
        {{ strtoupper($waiter['name']) }} - DAILY BREAKDOWN
        @if($isAisha)
            <span style="font-size: 12px; float: right;">(FIXED 10,000 TZS PER DAY)</span>
        @elseif($isTumaini)
            <span style="font-size: 12px; float: right;">(MONTHLY SALARY)</span>
        @endif
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Day</th>
                <th>Date</th>
                <th>Sales Count</th>
                <th>Total Sales (TZS)</th>
                <th>4% Value (TZS)</th>
                <th>Payment (TZS)</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($waiter['daily'] as $dayData)
            @php
                $fourPercentValue = $dayData['total_amount'] * 0.04;
                $formattedDate = \Carbon\Carbon::parse($dayData['date'])->format('j M');
            @endphp
            <tr>
                <td><strong>{{ $dayData['day_name'] }}</strong></td>
                <td>{{ $formattedDate }}</td>
                <td style="text-align:center;">{{ $dayData['sales_count'] }}</td>
                <td style="text-align:right;">{{ number_format($dayData['total_amount'], 0) }}</td>
                <td style="text-align:right;">
                    @if($isAisha || $isTumaini)
                        -
                    @else
                        {{ number_format($fourPercentValue, 0) }}
                    @endif
                </td>
                <td style="text-align:right;" class="{{ $isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : ($dayData['is_eligible'] ? 'eligible' : 'not-eligible')) }}">
                    @if($isAisha)
                        {{ number_format($dayData['payment'], 0) }}
                    @elseif($isTumaini)
                        MONTHLY
                    @else
                        {{ number_format($dayData['payment'], 0) }}
                    @endif
                </td>
                <td style="text-align:center;">
                    @if($isAisha)
                        <span style="color: #17a2b8;">FIXED RATE</span>
                    @elseif($isTumaini)
                        <span style="color: #6f42c1;">MONTHLY</span>
                    @else
                        {{ $dayData['is_eligible'] ? 'ELIGIBLE' : 'NOT ELIGIBLE' }}
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="3"><strong>WEEKLY TOTALS</strong></td>
                <td style="text-align:right;"><strong>{{ number_format($waiter['weekly_total_sales'], 0) }}</strong></td>
                <td style="text-align:right;"><strong>-</strong></td>
                <td style="text-align:right;" class="{{ $isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : 'eligible') }}">
                    <strong>
                        @if($isAisha)
                            {{ number_format($waiter['weekly_total_payment'], 0) }}
                        @elseif($isTumaini)
                            PAID MONTHLY
                        @else
                            {{ number_format($waiter['weekly_total_payment'], 0) }}
                        @endif
                    </strong>
                </td>
                <td></td>
            </tr>
        </tfoot>
    </table>
    @endforeach

    <div class="footer">
        <p><strong>Payment Formulas:</strong></p>
        <p>• <strong>Standard Waiters:</strong> IF(Sales ≥ 100,000 → ROUND(Sales × 4%, -3), ELSE 0)</p>
        <p>• <strong>Aisha Juma:</strong> Fixed 10,000 TZS per day worked</p>
        <p>• <strong>Tumaini George:</strong> Fixed monthly salary (excluded from weekly payroll)</p>
        <p>Weekly Payment = SUM of all daily payments (except Tumaini George - monthly salary).</p>
        <p>This is a system-generated report.</p>
    </div>
</body>
</html>