@extends('layouts.admin')

@section('title', 'Waiters Performance Reports')

@section('content')
<div class="content">
    <div class="pb-5">
        <!-- Header -->
        <div class="mb-8">
            <h2 class="mb-2">
                Waiters Performance Reports
            </h2>
            <p class="text-body-tertiary">Comprehensive performance analysis for all waiters</p>
        </div>

<!-- Waiters Quick Stats Row -->
<div class="row g-3 mb-6">
  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="flex-1">
            <h5 class="mb-1">Total Waiters</h5>
            <h2 class="mb-0 text-primary">{{ $waiters->count() }}</h2>
            <p class="fs-9 mb-0 text-muted">Active staff</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="flex-1">
            <h5 class="mb-1">Total Revenue</h5>
            <h2 class="mb-0 text-success">Tsh {{ number_format($waiters->sum('total_sales_amount'), 0) }}</h2>
            <p class="fs-9 mb-0 text-muted">Current period</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="flex-1">
            <h5 class="mb-1">Total Sales</h5>
            <h2 class="mb-0 text-info">{{ $waiters->sum('total_sales_count') }}</h2>
            <p class="fs-9 mb-0 text-muted">Transactions</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="flex-1">
            <h5 class="mb-1">Avg. Performance</h5>
            <h2 class="mb-0 text-warning">{{ number_format($waiters->avg('performance_score'), 1) }}/100</h2>
            <p class="fs-9 mb-0 text-muted">Team average</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


       <!-- Summary Cards - Simplified Professional Style -->
<div class="row g-4 mb-6">
  <!-- Today's Summary -->
  <div class="col-12 col-md-4">
    <div class="card">
      <div class="card-header bg-primary-soft py-3">
        <h6 class="mb-0 text-primary fw-bold">Today's Summary</h6>
      </div>
      <div class="card-body p-4">
        @php $todayData = $summaryData['today'] ?? []; @endphp

        <div class="row text-center g-3 mb-4">
          <div class="col-4 border-end">
            <h4 class="text-primary mb-1 fw-bold">{{ $todayData['total_sales'] ?? 0 }}</h4>
            <small class="text-muted">Sales</small>
          </div>
          <div class="col-4 border-end">
            <h4 class="text-success mb-1 fw-bold">Tsh {{ number_format($todayData['total_amount'] ?? 0, 0) }}</h4>
            <small class="text-muted">Revenue</small>
          </div>
          <div class="col-4">
            <h4 class="text-info mb-1 fw-bold">{{ $todayData['total_items'] ?? 0 }}</h4>
            <small class="text-muted">Items</small>
          </div>
        </div>

        <div class="bg-primary-subtle rounded-2 p-3">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <small class="text-muted">Active Waiters:</small>
            <strong class="text-primary">{{ $todayData['active_waiters'] ?? 0 }}</strong>
          </div>
          @if(!empty($summaryData['today_leaders']))
          <div class="d-flex justify-content-between align-items-center">
            <small class="text-muted">Top Performer:</small>
            <strong class="text-success">{{ $summaryData['today_leaders'][0]['name'] ?? 'N/A' }}</strong>
          </div>
          @endif
        </div>
      </div>
    </div>
  </div>

  <!-- This Week's Summary -->
  <div class="col-12 col-md-4">
    <div class="card">
      <div class="card-header bg-warning-soft py-3">
        <h6 class="mb-0 text-warning fw-bold">This Week's Summary</h6>
      </div>
      <div class="card-body p-4">
        @php $weekData = $summaryData['week'] ?? []; @endphp

        <div class="row text-center g-3 mb-4">
          <div class="col-4 border-end">
            <h4 class="text-primary mb-1 fw-bold">{{ $weekData['total_sales'] ?? 0 }}</h4>
            <small class="text-muted">Sales</small>
          </div>
          <div class="col-4 border-end">
            <h4 class="text-success mb-1 fw-bold">Tsh {{ number_format($weekData['total_amount'] ?? 0, 0) }}</h4>
            <small class="text-muted">Revenue</small>
          </div>
          <div class="col-4">
            <h4 class="text-info mb-1 fw-bold">{{ $weekData['total_items'] ?? 0 }}</h4>
            <small class="text-muted">Items</small>
          </div>
        </div>

        <div class="bg-primary-subtle rounded-2 p-3">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <small class="text-muted">Avg Daily:</small>
            <strong class="text-warning">Tsh {{ number_format($weekData['average_daily'] ?? 0, 0) }}</strong>
          </div>
          @if(!empty($summaryData['week_leaders']))
          <div class="d-flex justify-content-between align-items-center">
            <small class="text-muted">Top Performer:</small>
            <strong class="text-success">{{ $summaryData['week_leaders'][0]['name'] ?? 'N/A' }}</strong>
          </div>
          @endif
        </div>
      </div>
    </div>
  </div>

  <!-- This Month's Summary -->
  <div class="col-12 col-md-4">
    <div class="card">
      <div class="card-header bg-info-soft py-3">
        <h6 class="mb-0 text-info fw-bold">This Month's Summary</h6>
      </div>
      <div class="card-body p-4">
        @php $monthData = $summaryData['month'] ?? []; @endphp

        <div class="row text-center g-3 mb-4">
          <div class="col-4 border-end">
            <h4 class="text-primary mb-1 fw-bold">{{ $monthData['total_sales'] ?? 0 }}</h4>
            <small class="text-muted">Sales</small>
          </div>
          <div class="col-4 border-end">
            <h4 class="text-success mb-1 fw-bold">Tsh {{ number_format($monthData['total_amount'] ?? 0, 0) }}</h4>
            <small class="text-muted">Revenue</small>
          </div>
          <div class="col-4">
            <h4 class="text-info mb-1 fw-bold">{{ $monthData['total_items'] ?? 0 }}</h4>
            <small class="text-muted">Items</small>
          </div>
        </div>

        <div class="bg-primary-subtle rounded-2 p-3">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <small class="text-muted">Avg Daily:</small>
            <strong class="text-info">Tsh {{ number_format($monthData['average_daily'] ?? 0, 0) }}</strong>
          </div>
          @if(!empty($summaryData['month_leaders']))
          <div class="d-flex justify-content-between align-items-center">
            <small class="text-muted">Top Performer:</small>
            <strong class="text-success">{{ $summaryData['month_leaders'][0]['name'] ?? 'N/A' }}</strong>
          </div>
          @endif
        </div>
      </div>
    </div>
  </div>
</div>


        <!-- Performance Leaders -->
<div class="row g-4 mb-6">
  <!-- Today's Leaders -->
  <div class="col-12 col-lg-4">
    <div class="card h-100 shadow-sm border-0">
      <div class="card-header bg-primary-subtle border-bottom py-3">
        <h6 class="mb-0 fw-bold text-primary">Today's Leaders</h6>
      </div>
      <div class="card-body p-0">
        @php $todayLeaders = $summaryData['today_leaders'] ?? []; @endphp
        @forelse($todayLeaders as $index => $leader)
        <div class="d-flex align-items-center px-4 py-3 border-bottom hover-bg-soft-primary">
          <div class="flex-shrink-0 me-3">
<div class="rounded-circle bg-{{ $index == 0 ? 'warning' : ($index == 1 ? 'secondary' : ($index == 2 ? 'danger' : 'info')) }}-subtle 
            text-{{ $index == 0 ? 'warning-emphasis' : ($index == 1 ? 'secondary-emphasis' : ($index == 2 ? 'danger-emphasis' : 'info-emphasis')) }} 
            fw-bold d-flex align-items-center justify-content-center"
     style="width: 32px; height: 32px;">
  {{ $index + 1 }}
</div>

          </div>
          <div class="flex-grow-1">
            <div class="d-flex justify-content-between align-items-center mb-1">
              <h6 class="mb-0 small fw-semibold">{{ $leader['name'] }}</h6>
              <strong class="text-success small">Tsh {{ number_format($leader['amount'], 0) }}</strong>
            </div>
            <div class="d-flex justify-content-between text-muted small">
              <span>{{ $leader['sales'] }} sales</span>
              <span>{{ $leader['items'] }} items</span>
            </div>
          </div>
        </div>
        @empty
        <div class="text-center text-muted py-5">
          <i class="fas fa-users fa-2x mb-3 opacity-50"></i>
          <p class="mb-0 fw-medium">No sales activity today</p>
        </div>
        @endforelse
      </div>
    </div>
  </div>

  <!-- Weekly Leaders -->
  <div class="col-12 col-lg-4">
    <div class="card h-100 shadow-sm border-0">
      <div class="card-header bg-primary-subtle border-bottom py-3">
        <h6 class="mb-0 fw-bold text-success">Weekly Leaders</h6>
      </div>
      <div class="card-body p-0">
        @php $weekLeaders = $summaryData['week_leaders'] ?? []; @endphp
        @forelse($weekLeaders as $index => $leader)
        <div class="d-flex align-items-center px-4 py-3 border-bottom hover-bg-soft-success">
          <div class="flex-shrink-0 me-3">
<div class="rounded-circle bg-{{ $index == 0 ? 'warning' : ($index == 1 ? 'secondary' : ($index == 2 ? 'danger' : 'info')) }}-subtle 
            text-{{ $index == 0 ? 'warning-emphasis' : ($index == 1 ? 'secondary-emphasis' : ($index == 2 ? 'danger-emphasis' : 'info-emphasis')) }} 
            fw-bold d-flex align-items-center justify-content-center"
     style="width: 32px; height: 32px;">
  {{ $index + 1 }}
</div>

          </div>
          <div class="flex-grow-1">
            <div class="d-flex justify-content-between align-items-center mb-1">
              <h6 class="mb-0 small fw-semibold">{{ $leader['name'] }}</h6>
              <strong class="text-success small">Tsh {{ number_format($leader['amount'], 0) }}</strong>
            </div>
            <div class="d-flex justify-content-between text-muted small">
              <span>{{ $leader['sales'] }} sales</span>
              <span>{{ $leader['items'] }} items</span>
            </div>
          </div>
        </div>
        @empty
        <div class="text-center text-muted py-5">
          <i class="fas fa-users fa-2x mb-3 opacity-50"></i>
          <p class="mb-0 fw-medium">No sales this week</p>
        </div>
        @endforelse
      </div>
    </div>
  </div>

  <!-- Monthly Leaders -->
  <div class="col-12 col-lg-4">
    <div class="card h-100 shadow-sm border-0">
     <div class="card-header bg-primary-subtle border-bottom py-3">
        <h6 class="mb-0 fw-bold text-warning">Monthly Leaders</h6>
      </div>
      <div class="card-body p-0">
        @php $monthLeaders = $summaryData['month_leaders'] ?? []; @endphp
        @forelse($monthLeaders as $index => $leader)
        <div class="d-flex align-items-center px-4 py-3 border-bottom hover-bg-soft-warning">
          <div class="flex-shrink-0 me-3">
<div class="rounded-circle bg-{{ $index == 0 ? 'warning' : ($index == 1 ? 'secondary' : ($index == 2 ? 'danger' : 'info')) }}-subtle 
            text-{{ $index == 0 ? 'warning-emphasis' : ($index == 1 ? 'secondary-emphasis' : ($index == 2 ? 'danger-emphasis' : 'info-emphasis')) }} 
            fw-bold d-flex align-items-center justify-content-center"
     style="width: 32px; height: 32px;">
  {{ $index + 1 }}
</div>

          </div>
          <div class="flex-grow-1">
            <div class="d-flex justify-content-between align-items-center mb-1">
              <h6 class="mb-0 small fw-semibold">{{ $leader['name'] }}</h6>
              <strong class="text-success small">Tsh {{ number_format($leader['amount'], 0) }}</strong>
            </div>
            <div class="d-flex justify-content-between text-muted small">
              <span>{{ $leader['sales'] }} sales</span>
              <span>{{ $leader['items'] }} items</span>
            </div>
          </div>
        </div>
        @empty
        <div class="text-center text-muted py-5">
          <i class="fas fa-users fa-2x mb-3 opacity-50"></i>
          <p class="mb-0 fw-medium">No sales this month</p>
        </div>
        @endforelse
      </div>
    </div>
  </div>
</div>


        <!-- Filters Card -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Report Filters</h5>
            </div>
            <div class="card-body">
                <form id="filterForm" method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Time Period</label>
                        <select name="filter" class="form-select" id="filterSelect">
                            <option value="today" {{ $filter == 'today' ? 'selected' : '' }}>Today</option>
                            <option value="yesterday" {{ $filter == 'yesterday' ? 'selected' : '' }}>Yesterday</option>
                            <option value="week" {{ $filter == 'week' ? 'selected' : '' }}>This Week</option>
                            <option value="month" {{ $filter == 'month' ? 'selected' : '' }}>This Month</option>
                            <option value="year" {{ $filter == 'year' ? 'selected' : '' }}>This Year</option>
                        </select>
                    </div>
                    
                    <div class="col-md-3" id="dateField" style="{{ !in_array($filter, ['today', 'yesterday']) ? 'display: none;' : '' }}">
                        <label class="form-label">Date</label>
                        <input type="date" name="date" class="form-control" value="{{ $date }}">
                    </div>
                    
                    <div class="col-md-3" id="weekField" style="{{ $filter != 'week' ? 'display: none;' : '' }}">
                        <label class="form-label">Week Number</label>
                        <input type="number" name="week" class="form-control" min="1" max="52" value="{{ $week }}">
                    </div>
                    
                    <div class="col-md-3" id="monthField" style="{{ $filter != 'month' ? 'display: none;' : '' }}">
                        <label class="form-label">Month</label>
                        <select name="month" class="form-select">
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ $month == $i ? 'selected' : '' }}>
                                    {{ DateTime::createFromFormat('!m', $i)->format('F') }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    
                    <div class="col-md-3" id="yearField" style="{{ !in_array($filter, ['week', 'month', 'year']) ? 'display: none;' : '' }}">
                        <label class="form-label">Year</label>
                        <input type="number" name="year" class="form-control" value="{{ $year }}" min="2020" max="2030">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Sort By</label>
                        <select name="sort" class="form-select" onchange="this.form.submit()">
                            <option value="amount" {{ request('sort') == 'amount' ? 'selected' : '' }}>Revenue (High to Low)</option>
                            <option value="sales" {{ request('sort') == 'sales' ? 'selected' : '' }}>Sales Count</option>
                            <option value="items" {{ request('sort') == 'items' ? 'selected' : '' }}>Items Sold</option>
                            <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Name (A-Z)</option>
                        </select>
                    </div>

                    <div class="col-12">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-muted">{{ $waiters->count() }} waiters found</span>
                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.waiters.reports') }}" class="btn btn-phoenix-secondary btn-sm">
                                    <i class="fas fa-redo me-1"></i> Reset
                                </a>
                                <button type="submit" class="btn btn-phoenix-primary btn-sm">
                                    <i class="fas fa-search me-1"></i> Apply
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Waiters Performance Grid -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>
                    <h5 class="mb-1">Waiters Performance Details</h5>
                    <p class="text-muted mb-0">Individual performance metrics and analytics</p>
                </div>
                <div class="d-flex gap-2">
                    <span class="badge badge-phoenix badge-phoenix-primary">{{ $waiters->count() }} Waiters</span>
                    <div class="dropdown">
                        <button class="btn btn-phoenix-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog me-1"></i>Options
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="exportTableToCSV('waiters_performance.csv')">
                                <i class="fas fa-file-csv me-2"></i>Export as CSV
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="window.print()">
                                <i class="fas fa-print me-2"></i>Print Report
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('admin.waiters.reports') }}">
                                <i class="fas fa-sync me-2"></i>Refresh Data
                            </a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-4" id="waitersGrid">
                    @foreach($waiters as $waiter)
                    <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                        <div class="card h-100 waiter-card" data-waiter-id="{{ $waiter['id'] }}">
                            <div class="card-body position-relative">
                                <!-- Performance Badge -->
                                <div class="position-absolute top-0 end-0 m-3">
                                    @if($waiter['performance_score'] >= 90)
                                        <span class="badge badge-phoenix badge-phoenix-success">Excellent</span>
                                    @elseif($waiter['performance_score'] >= 75)
                                        <span class="badge badge-phoenix badge-phoenix-primary">Great</span>
                                    @elseif($waiter['performance_score'] >= 60)
                                        <span class="badge badge-phoenix badge-phoenix-warning">Good</span>
                                    @else
                                        <span class="badge badge-phoenix badge-phoenix-secondary">Needs Improvement</span>
                                    @endif
                                </div>

                                <!-- Waiter Info -->
                                <div class="d-flex align-items-center mb-3">
                                    <div class="avatar avatar-lg me-3">
                                        @if($waiter['avatar'])
                                            <img src="{{ asset($waiter['avatar']) }}" class="rounded-circle" alt="{{ $waiter['name'] }}">
                                        @else
                                            <div class="avatar-name rounded-circle bg-primary d-flex align-items-center justify-content-center">
                                                <span class="text-white fw-bold">{{ substr($waiter['name'], 0, 1) }}</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-0 text-truncate">{{ $waiter['name'] }}</h6>
                                        <small class="text-muted">Waiter ID: #{{ $waiter['id'] }}</small>
                                    </div>
                                </div>

                                <!-- Key Metrics -->
                                <div class="row text-center g-2 mb-3">
                                    <div class="col-4">
                                        <div class="border rounded p-2 bg-primary-subtle">
                                            <h6 class="mb-0 text-primary">{{ $waiter['total_sales_count'] }}</h6>
                                            <small class="text-muted">Sales</small>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="border rounded p-2 bg-primary-subtle">
                                            <h6 class="mb-0 text-success">Tsh {{ number_format($waiter['total_sales_amount'], 0) }}</h6>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="border rounded p-2 bg-primary-subtle">
                                            <h6 class="mb-0 text-info">{{ $waiter['total_items_sold'] }}</h6>
                                            <small class="text-muted">Items</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Growth Indicators -->
                                <div class="row g-1 mb-3">
                                    <div class="col-4 text-center">
                                        <small class="d-block fw-bold {{ $waiter['sales_growth'] >= 0 ? 'text-success' : 'text-danger' }}">
                                            <i class="fas fa-arrow-{{ $waiter['sales_growth'] >= 0 ? 'up' : 'down' }} me-1"></i>
                                            {{ number_format($waiter['sales_growth'], 1) }}%
                                        </small>
                                        <small class="text-muted">Sales</small>
                                    </div>
                                    <div class="col-4 text-center">
                                        <small class="d-block fw-bold {{ $waiter['amount_growth'] >= 0 ? 'text-success' : 'text-danger' }}">
                                            <i class="fas fa-arrow-{{ $waiter['amount_growth'] >= 0 ? 'up' : 'down' }} me-1"></i>
                                            {{ number_format($waiter['amount_growth'], 1) }}%
                                        </small>
                                        <small class="text-muted">Revenue</small>
                                    </div>
                                    <div class="col-4 text-center">
                                        <small class="d-block fw-bold {{ $waiter['items_growth'] >= 0 ? 'text-success' : 'text-danger' }}">
                                            <i class="fas fa-arrow-{{ $waiter['items_growth'] >= 0 ? 'up' : 'down' }} me-1"></i>
                                            {{ number_format($waiter['items_growth'], 1) }}%
                                        </small>
                                        <small class="text-muted">Items</small>
                                    </div>
                                </div>

                                <!-- Performance Score -->
                                <div class="mb-3 text-center">
                                    <small class="text-muted d-block mb-1">Performance Score</small>
                                    <h5 class="text-{{ $waiter['performance_score'] >= 80 ? 'success' : ($waiter['performance_score'] >= 60 ? 'warning' : 'danger') }}">
                                        {{ number_format($waiter['performance_score'], 1) }}/100
                                    </h5>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-grid gap-2">
                                    <a href="{{ route('admin.waiters.reports.show', $waiter['id']) }}?filter={{ $filter }}&date={{ $date }}&week={{ $week }}&month={{ $month }}&year={{ $year }}" 
                                       class="btn btn-phoenix-primary btn-sm">
                                        <i class="fas fa-chart-line me-1"></i> View Detailed Report
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach

                    @if($waiters->isEmpty())
                    <div class="col-12">
                        <div class="text-center py-5">
                            <i class="fas fa-users text-muted fa-4x mb-3"></i>
                            <h5 class="text-muted">No Waiters Found</h5>
                            <p class="text-muted mb-4">No waiters match the current filter criteria.</p>
                            <a href="{{ route('admin.waiters.reports') }}" class="btn btn-phoenix-primary">
                                <i class="fas fa-redo me-1"></i> Reset Filters
                            </a>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.waiter-card {
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
    cursor: pointer;
}
.waiter-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    border-color: #007bff;
}
.avatar-name {
    width: 48px;
    height: 48px;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    font-weight: 600;
}
.card-header {
    border-bottom: 1px solid #e9ecef;
}
.badge {
    font-size: 0.75em;
}

/* Phoenix Style Enhancements */
.hover-box-shadow {
    transition: all 0.3s ease;
}
.hover-box-shadow:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}
.bg-primary-soft {
    background-color: rgba(13, 110, 253, 0.08) !important;
}
.bg-success-soft {
    background-color: rgba(25, 135, 84, 0.08) !important;
}
.bg-info-soft {
    background-color: rgba(13, 202, 240, 0.08) !important;
}
.bg-warning-soft {
    background-color: rgba(255, 193, 7, 0.08) !important;
}
.bg-danger-soft {
    background-color: rgba(220, 53, 69, 0.08) !important;
}
.bg-secondary-soft {
    background-color: rgba(108, 117, 125, 0.08) !important;
}
.hover-bg-soft-primary:hover {
    background-color: rgba(13, 110, 253, 0.04) !important;
}
.text-primary-dark {
    color: #0a58ca !important;
}
.text-success-dark {
    color: #146c43 !important;
}
.text-info-dark {
    color: #087990 !important;
}
.text-warning-dark {
    color: #997404 !important;
}
.border-200 {
    border-color: #e9ecef !important;
}

@media print {
    .btn, .dropdown, .card-footer {
        display: none !important;
    }
    .card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
    }
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Filter form handling
    const filterSelect = document.getElementById('filterSelect');
    const dateField = document.getElementById('dateField');
    const weekField = document.getElementById('weekField');
    const monthField = document.getElementById('monthField');
    const yearField = document.getElementById('yearField');

    filterSelect.addEventListener('change', function() {
        const value = this.value;
        
        // Hide all fields first
        dateField.style.display = 'none';
        weekField.style.display = 'none';
        monthField.style.display = 'none';
        yearField.style.display = 'none';

        // Show relevant fields
        if (['today', 'yesterday'].includes(value)) {
            dateField.style.display = 'block';
        }
        if (value === 'week') {
            weekField.style.display = 'block';
            yearField.style.display = 'block';
        }
        if (value === 'month') {
            monthField.style.display = 'block';
            yearField.style.display = 'block';
        }
        if (value === 'year') {
            yearField.style.display = 'block';
        }
    });

    // Waiter card click handling
    document.querySelectorAll('.waiter-card').forEach(card => {
        card.addEventListener('click', function(e) {
            if (!e.target.closest('a') && !e.target.closest('button')) {
                const waiterId = this.getAttribute('data-waiter-id');
                const url = `{{ route('admin.waiters.reports.show', ':id') }}`.replace(':id', waiterId) +
                    `?filter={{ $filter }}&date={{ $date }}&week={{ $week }}&month={{ $month }}&year={{ $year }}`;
                window.location.href = url;
            }
        });
    });
});

function exportTableToCSV(filename) {
    const csv = [];
    const rows = document.querySelectorAll('.waiter-card');
    
    // Add headers
    csv.push(['Name', 'Sales Count', 'Revenue', 'Items Sold', 'Performance Score', 'Sales Growth', 'Revenue Growth', 'Items Growth']);
    
    // Add data
    rows.forEach(row => {
        const name = row.querySelector('h6').textContent.trim();
        const sales = row.querySelector('.text-primary').textContent.trim();
        const revenue = row.querySelector('.text-success').textContent.trim();
        const items = row.querySelector('.text-info').textContent.trim();
        const performance = row.querySelector('h5').textContent.trim();
        const growthElements = row.querySelectorAll('.fw-bold.text-success, .fw-bold.text-danger');
        
        csv.push([
            name,
            sales,
            revenue.replace('Tsh ', ''),
            items,
            performance,
            growthElements[0]?.textContent.replace('%', '') || '0',
            growthElements[1]?.textContent.replace('%', '') || '0',
            growthElements[2]?.textContent.replace('%', '') || '0'
        ]);
    });
    
    // Download CSV
    downloadCSV(csv.join('\n'), filename);
}

function downloadCSV(csv, filename) {
    const csvFile = new Blob([csv], { type: 'text/csv' });
    const downloadLink = document.createElement('a');
    downloadLink.download = filename;
    downloadLink.href = window.URL.createObjectURL(csvFile);
    downloadLink.style.display = 'none';
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);
}
</script>
@endpush