@extends('layouts.admin')

@section('title', $waiter->name . ' - Performance Report')

@section('content')
<div class="content">
    <div class="pb-5">
        <!-- Header -->
        <div class="mb-8">
            <h2 class="mb-2">
                Waiter Performance Report
            </h2>
            <p class="text-body-tertiary">Detailed analysis for {{ $waiter->name }} - {{ $filter }} data</p>
        </div>

        <!-- Today's Stats Row -->
        <div class="row g-3 mb-4">
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Today's Sales</h5>
                                <h2 class="mb-0 text-primary">{{ $todayStats['sales'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($todayStats['sales_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($todayStats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($todayStats['sales_growth'] ?? 0, 1) }}% vs yesterday
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Today's Revenue</h5>
                                <h2 class="mb-0 text-success">Tsh {{ number_format($todayStats['amount'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 {{ ($todayStats['amount_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($todayStats['amount_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($todayStats['amount_growth'] ?? 0, 1) }}% vs yesterday
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Today's Items</h5>
                                <h2 class="mb-0 text-info">{{ $todayStats['items'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($todayStats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($todayStats['items_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($todayStats['items_growth'] ?? 0, 1) }}% vs yesterday
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Today's Average</h5>
                                <h2 class="mb-0 text-warning">Tsh {{ number_format($todayStats['average_daily'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 text-body-tertiary">Average sale value</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Weekly Stats Row -->
        <div class="row g-3 mb-4">
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">This Week Sales</h5>
                                <h2 class="mb-0 text-primary">{{ $weeklyStats['sales'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($weeklyStats['sales_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($weeklyStats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($weeklyStats['sales_growth'] ?? 0, 1) }}% vs last week
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Weekly Revenue</h5>
                                <h2 class="mb-0 text-success">Tsh {{ number_format($weeklyStats['amount'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 {{ ($weeklyStats['amount_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($weeklyStats['amount_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($weeklyStats['amount_growth'] ?? 0, 1) }}% vs last week
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Weekly Items</h5>
                                <h2 class="mb-0 text-info">{{ $weeklyStats['items'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($weeklyStats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($weeklyStats['items_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($weeklyStats['items_growth'] ?? 0, 1) }}% vs last week
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Avg. Daily</h5>
                                <h2 class="mb-0 text-warning">Tsh {{ number_format($weeklyStats['average_daily'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 text-body-tertiary">Per day this week</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Stats Row -->
        <div class="row g-3 mb-6">
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">This Month Sales</h5>
                                <h2 class="mb-0 text-primary">{{ $monthlyStats['sales'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($monthlyStats['sales_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($monthlyStats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($monthlyStats['sales_growth'] ?? 0, 1) }}% vs last month
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Monthly Revenue</h5>
                                <h2 class="mb-0 text-success">Tsh {{ number_format($monthlyStats['amount'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 {{ ($monthlyStats['amount_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($monthlyStats['amount_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($monthlyStats['amount_growth'] ?? 0, 1) }}% vs last month
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Monthly Items</h5>
                                <h2 class="mb-0 text-info">{{ $monthlyStats['items'] ?? 0 }}</h2>
                                <p class="fs-9 mb-0 {{ ($monthlyStats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    <span class="fas fa-arrow-{{ ($monthlyStats['items_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                    {{ number_format($monthlyStats['items_growth'] ?? 0, 1) }}% vs last month
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-1">
                                <h5 class="mb-1">Avg. Daily</h5>
                                <h2 class="mb-0 text-warning">Tsh {{ number_format($monthlyStats['average_daily'] ?? 0, 0) }}</h2>
                                <p class="fs-9 mb-0 text-body-tertiary">Per day this month</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Rest of your existing code remains the same -->
        <!-- Monthly Performance Table -->
        <div class="row g-3 mb-6">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1">Monthly Performance - {{ $year }}</h5>
                            <h6 class="text-body-tertiary">Yearly breakdown by weeks</h6>
                        </div>
                        <div class="d-flex gap-2">
                            <select class="form-select form-select-sm" style="width: auto;" onchange="window.location.href = this.value">
                                <option value="{{ route('admin.waiters.reports.show', $waiter) }}?filter={{ $filter }}&year={{ date('Y') }}" {{ $year == date('Y') ? 'selected' : '' }}>{{ date('Y') }}</option>
                                <option value="{{ route('admin.waiters.reports.show', $waiter) }}?filter={{ $filter }}&year={{ date('Y')-1 }}" {{ $year == date('Y')-1 ? 'selected' : '' }}>{{ date('Y')-1 }}</option>
                            </select>
                            <a href="{{ route('admin.waiters.reports.export', $waiter) }}?filter={{ $filter }}&date={{ $date }}&week={{ $week }}&month={{ $month }}&year={{ $year }}" 
                               class="btn btn-sm btn-phoenix-danger" target="_blank">
                                <i class="fas fa-file-pdf me-1"></i> Export PDF
                            </a>
                            <a href="{{ route('admin.waiters.reports') }}?filter={{ $filter }}&date={{ $date }}&week={{ $week }}&month={{ $month }}&year={{ $year }}" 
                               class="btn btn-sm btn-phoenix-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Back
                            </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive" style="overflow-x: auto;">
                            <table class="table table-hover mb-0">
                                <thead class="bg-body-secondary">
                                    <tr>
                                        <th class="ps-4">Month</th>
                                        <th class="text-center">Week 1</th>
                                        <th class="text-center">Week 2</th>
                                        <th class="text-center">Week 3</th>
                                        <th class="text-center">Week 4</th>
                                        <th class="text-center">Week 5</th>
                                        <th class="text-end pe-4">Monthly Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($monthlyPerformance as $monthData)
                                    <tr>
                                        <td class="ps-4 fw-semibold">{{ $monthData['month_name'] }}</td>
                                        @foreach($monthData['weeks'] as $weekIndex => $week)
                                        <td class="text-center">
                                            @if($week['sales'] > 0)
                                                <div class="d-flex flex-column">
                                                    <span class="fw-bold text-primary">{{ $week['sales'] }}</span>
                                                    <small class="text-muted">Tsh {{ number_format($week['amount'], 0) }}</small>
                                                </div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        @endforeach
                                        <td class="text-end pe-4">
                                            <div class="d-flex flex-column align-items-end">
                                                <span class="fw-bold text-success">{{ $monthData['total_sales'] }} sales</span>
                                                <span class="text-success">Tsh {{ number_format($monthData['total_amount'], 0) }}</span>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                    <!-- Yearly Total -->
                                    <tr class="table-active fw-bold">
                                        <td class="ps-4">Year {{ $year }} Total</td>
                                        <td colspan="5"></td>
                                        <td class="text-end pe-4">
                                            <div class="d-flex flex-column align-items-end">
                                                <span class="text-success">{{ $yearlyTotal['sales'] }} sales</span>
                                                <span class="text-success">Tsh {{ number_format($yearlyTotal['amount'], 0) }}</span>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detailed Analysis Sections in Tabs -->
<div class="row g-3 mb-6">
    <div class="col-12">
        <div class="card">
            <div class="card-header border-bottom">
                <ul class="nav nav-tabs card-header-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#today-tab" role="tab">
                            <i class="fas fa-calendar-day me-2"></i>Today
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#weekly-tab" role="tab">
                            <i class="fas fa-calendar-week me-2"></i>This Week
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#monthly-tab" role="tab">
                            <i class="fas fa-calendar-alt me-2"></i>This Month
                        </a>
                    </li>
                    @if(!empty($hourlyPerformance) && count($hourlyPerformance) > 0)
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#hourly-tab" role="tab">
                            <i class="fas fa-clock me-2"></i>Today's Hourly Performance
                        </a>
                    </li>
                    @endif
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content">
                    <!-- Today's Breakdown Tab (Default) -->
                    <div class="tab-pane fade show active" id="today-tab" role="tabpanel">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-primary">Total Sales</h5>
                                        <h3 class="text-primary">{{ $todayBreakdown['totalSales'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Transactions</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-success">Revenue</h5>
                                        <h3 class="text-success">Tsh {{ number_format($todayBreakdown['totalAmount'] ?? 0, 0) }}</h3>
                                        <p class="text-muted mb-0">Total Amount</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-info">Items Sold</h5>
                                        <h3 class="text-info">{{ $todayBreakdown['totalItems'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Items</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Status Breakdown -->
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Sales Status - Today</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th class="text-end">Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $statusTotalCount = 0;
                                                $statusTotalAmount = 0;
                                            @endphp
                                            @foreach($todayBreakdown['statusBreakdown'] as $status => $data)
                                            @php
                                                $statusTotalCount += $data['count'];
                                                $statusTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    @if($status == 'verified')
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-success">
                                                        <span class="badge-label">Verified</span>
                                                    </span>
                                                    @else
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-warning">
                                                        <span class="badge-label">Pending</span>
                                                    </span>
                                                    @endif
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $todayBreakdown['totalSales'] > 0 ? number_format(($data['count'] / $todayBreakdown['totalSales']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $statusTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($statusTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Payment Methods -->
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Payment Methods - Today</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Payment Method</th>
                                                <th class="text-end">Sales Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $paymentTotalCount = 0;
                                                $paymentTotalAmount = 0;
                                            @endphp
                                            @foreach($todayBreakdown['paymentBreakdown'] as $method => $data)
                                            @php
                                                $paymentTotalCount += $data['count'];
                                                $paymentTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-{{ $method == 'Cash' ? 'primary' : 'info' }}">
                                                        <span class="badge-label">{{ $method }}</span>
                                                    </span>
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $todayBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $todayBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $paymentTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($paymentTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Items Today -->
                        <div class="row">
                            <div class="col-12">
                                <h6 class="mb-3">Top Selling Items - Today</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Item</th>
                                                <th class="text-end">Quantity</th>
                                                <th class="text-end">Revenue</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $itemsTotalQuantity = 0;
                                                $itemsTotalAmount = 0;
                                            @endphp
                                            @foreach($todayBreakdown['topItems'] as $item => $data)
                                            @php
                                                $itemsTotalQuantity += $data['quantity'];
                                                $itemsTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>{{ $item }}</td>
                                                <td class="text-end">{{ $data['quantity'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $todayBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $todayBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $itemsTotalQuantity }}</td>
                                                <td class="text-end">Tsh {{ number_format($itemsTotalAmount, 0) }}</td>
                                                <td class="text-end">
                                                    {{ $todayBreakdown['totalAmount'] > 0 ? number_format(($itemsTotalAmount / $todayBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Weekly Breakdown Tab -->
                    <div class="tab-pane fade" id="weekly-tab" role="tabpanel">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-primary">Total Sales</h5>
                                        <h3 class="text-primary">{{ $weeklyBreakdown['totalSales'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">This Week</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-success">Revenue</h5>
                                        <h3 class="text-success">Tsh {{ number_format($weeklyBreakdown['totalAmount'] ?? 0, 0) }}</h3>
                                        <p class="text-muted mb-0">This Week</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-info">Items Sold</h5>
                                        <h3 class="text-info">{{ $weeklyBreakdown['totalItems'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">This Week</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Sales Status - This Week</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th class="text-end">Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $statusTotalCount = 0;
                                                $statusTotalAmount = 0;
                                            @endphp
                                            @foreach($weeklyBreakdown['statusBreakdown'] as $status => $data)
                                            @php
                                                $statusTotalCount += $data['count'];
                                                $statusTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    @if($status == 'verified')
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-success">Verified</span>
                                                    @else
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-warning">Pending</span>
                                                    @endif
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $weeklyBreakdown['totalSales'] > 0 ? number_format(($data['count'] / $weeklyBreakdown['totalSales']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $statusTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($statusTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Payment Methods - This Week</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Payment Method</th>
                                                <th class="text-end">Sales Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $paymentTotalCount = 0;
                                                $paymentTotalAmount = 0;
                                            @endphp
                                            @foreach($weeklyBreakdown['paymentBreakdown'] as $method => $data)
                                            @php
                                                $paymentTotalCount += $data['count'];
                                                $paymentTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-{{ $method == 'Cash' ? 'primary' : 'info' }}">
                                                        {{ $method }}
                                                    </span>
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $weeklyBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $weeklyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $paymentTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($paymentTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Items Weekly -->
                        <div class="row">
                            <div class="col-12">
                                <h6 class="mb-3">Top Selling Items - This Week</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Item</th>
                                                <th class="text-end">Quantity</th>
                                                <th class="text-end">Revenue</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $itemsTotalQuantity = 0;
                                                $itemsTotalAmount = 0;
                                            @endphp
                                            @foreach($weeklyBreakdown['topItems'] as $item => $data)
                                            @php
                                                $itemsTotalQuantity += $data['quantity'];
                                                $itemsTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>{{ $item }}</td>
                                                <td class="text-end">{{ $data['quantity'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $weeklyBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $weeklyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $itemsTotalQuantity }}</td>
                                                <td class="text-end">Tsh {{ number_format($itemsTotalAmount, 0) }}</td>
                                                <td class="text-end">
                                                    {{ $weeklyBreakdown['totalAmount'] > 0 ? number_format(($itemsTotalAmount / $weeklyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Monthly Breakdown Tab -->
                    <div class="tab-pane fade" id="monthly-tab" role="tabpanel">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-primary">Total Sales</h5>
                                        <h3 class="text-primary">{{ $monthlyBreakdown['totalSales'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">This Month</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-success">Revenue</h5>
                                        <h3 class="text-success">Tsh {{ number_format($monthlyBreakdown['totalAmount'] ?? 0, 0) }}</h3>
                                        <p class="text-muted mb-0">This Month</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-primary-subtle">
                                    <div class="card-body text-center">
                                        <h5 class="text-info">Items Sold</h5>
                                        <h3 class="text-info">{{ $monthlyBreakdown['totalItems'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">This Month</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Sales Status - This Month</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th class="text-end">Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $statusTotalCount = 0;
                                                $statusTotalAmount = 0;
                                            @endphp
                                            @foreach($monthlyBreakdown['statusBreakdown'] as $status => $data)
                                            @php
                                                $statusTotalCount += $data['count'];
                                                $statusTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    @if($status == 'verified')
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-success">Verified</span>
                                                    @else
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-warning">Pending</span>
                                                    @endif
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $monthlyBreakdown['totalSales'] > 0 ? number_format(($data['count'] / $monthlyBreakdown['totalSales']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $statusTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($statusTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">Payment Methods - This Month</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Payment Method</th>
                                                <th class="text-end">Sales Count</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $paymentTotalCount = 0;
                                                $paymentTotalAmount = 0;
                                            @endphp
                                            @foreach($monthlyBreakdown['paymentBreakdown'] as $method => $data)
                                            @php
                                                $paymentTotalCount += $data['count'];
                                                $paymentTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="badge badge-phoenix fs-10 badge-phoenix-{{ $method == 'Cash' ? 'primary' : 'info' }}">
                                                        {{ $method }}
                                                    </span>
                                                </td>
                                                <td class="text-end">{{ $data['count'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $monthlyBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $monthlyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $paymentTotalCount }}</td>
                                                <td class="text-end">Tsh {{ number_format($paymentTotalAmount, 0) }}</td>
                                                <td class="text-end">100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Items Monthly -->
                        <div class="row">
                            <div class="col-12">
                                <h6 class="mb-3">Top Selling Items - This Month</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Item</th>
                                                <th class="text-end">Quantity</th>
                                                <th class="text-end">Revenue</th>
                                                <th class="text-end">Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $itemsTotalQuantity = 0;
                                                $itemsTotalAmount = 0;
                                            @endphp
                                            @foreach($monthlyBreakdown['topItems'] as $item => $data)
                                            @php
                                                $itemsTotalQuantity += $data['quantity'];
                                                $itemsTotalAmount += $data['amount'];
                                            @endphp
                                            <tr>
                                                <td>{{ $item }}</td>
                                                <td class="text-end">{{ $data['quantity'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">
                                                    {{ $monthlyBreakdown['totalAmount'] > 0 ? number_format(($data['amount'] / $monthlyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $itemsTotalQuantity }}</td>
                                                <td class="text-end">Tsh {{ number_format($itemsTotalAmount, 0) }}</td>
                                                <td class="text-end">
                                                    {{ $monthlyBreakdown['totalAmount'] > 0 ? number_format(($itemsTotalAmount / $monthlyBreakdown['totalAmount']) * 100, 1) : 0 }}%
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                            <!-- Hourly Performance Tab -->
                            @if(!empty($hourlyPerformance) && count($hourlyPerformance) > 0)
                            <div class="tab-pane fade" id="hourly-tab" role="tabpanel">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped">
                                        <thead>
                                            <tr>
                                                <th>Hour</th>
                                                <th class="text-end">Sales</th>
                                                <th class="text-end">Amount</th>
                                                <th class="text-end">Items</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $hourlyTotalSales = 0;
                                                $hourlyTotalAmount = 0;
                                                $hourlyTotalItems = 0;
                                            @endphp
                                            @foreach($hourlyPerformance as $hour => $data)
                                            @php
                                                $hourlyTotalSales += $data['sales'];
                                                $hourlyTotalAmount += $data['amount'];
                                                $hourlyTotalItems += $data['items'];
                                            @endphp
                                            <tr>
                                                <td>{{ sprintf('%02d:00', $hour) }}</td>
                                                <td class="text-end">{{ $data['sales'] }}</td>
                                                <td class="text-end">Tsh {{ number_format($data['amount'], 0) }}</td>
                                                <td class="text-end">{{ $data['items'] }}</td>
                                            </tr>
                                            @endforeach
                                            <!-- Hourly Total Row -->
                                            <tr class="table-active fw-bold">
                                                <td>Total</td>
                                                <td class="text-end">{{ $hourlyTotalSales }}</td>
                                                <td class="text-end">Tsh {{ number_format($hourlyTotalAmount, 0) }}</td>
                                                <td class="text-end">{{ $hourlyTotalItems }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif
                </div>
            </div>
        </div>
    </div>
</div>

        <!-- Recent Sales Table -->
        <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis pt-7 border-y mt-6">
            <div data-list='{"valueNames":["product","customer","rating","review","time"],"page":6}'>
                <div class="row align-items-end justify-content-between pb-5 g-3">
                    <div class="col-auto">
                        <h3>Recent Sales</h3>
                        <p class="text-body-tertiary lh-sm mb-0">All transactions by {{ $waiter->name }}</p>
                    </div>
                    <div class="col-12 col-md-auto">
                        <div class="row g-2 gy-3">
                            <div class="col-auto flex-1">
                                <div class="search-box">
                                    <form class="position-relative">
                                        <input class="form-control search-input search form-control-sm" type="search" placeholder="Search sales..." aria-label="Search" />
                                        <span class="fas fa-search search-box-icon"></span>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive mx-n1 px-1 scrollbar">
                    <table class="table fs-9 mb-0 border-top border-translucent">
                        <thead>
                            <tr>
                                <th class="white-space-nowrap fs-9 ps-0 align-middle">
                                    <div class="form-check mb-0 fs-8">
                                        <input class="form-check-input" id="checkbox-bulk-sales-select" type="checkbox" data-bulk-select='{"body":"table-latest-sales-body"}' />
                                    </div>
                                </th>
                                <th class="sort white-space-nowrap align-middle" scope="col" data-sort="id">ID</th>
                                <th class="sort align-middle" scope="col" data-sort="customer" style="min-width:200px;">CUSTOMER/Waiter</th>
                                <th class="sort align-middle" scope="col" data-sort="cashier" style="min-width:150px;">CASHIER</th>
                                <th class="sort align-middle" scope="col" data-sort="amount" style="min-width:120px;">AMOUNT</th>
                                <th class="sort align-middle" scope="col" data-sort="payment" style="min-width:130px;">PAYMENT</th>
                                <th class="sort align-middle" scope="col" style="max-width:200px;" data-sort="items">ITEMS</th>
                                <th class="sort text-start ps-5 align-middle" scope="col" data-sort="status">STATUS</th>
                                <th class="sort text-end align-middle" scope="col" data-sort="time">TIME</th>
                            </tr>
                        </thead>
                        <tbody class="list" id="table-latest-sales-body">
                            @foreach($sales as $sale)
                            <tr class="hover-actions-trigger btn-reveal-trigger position-static">
                                <td class="fs-9 align-middle ps-0">
                                    <div class="form-check mb-0 fs-8">
                                        <input class="form-check-input" type="checkbox" data-bulk-select-row='{"id":"{{ $sale->id }}","customer":"{{ $sale->waiter->name ?? 'N/A' }}","amount":"{{ number_format($sale->total, 2) }}","status":"{{ $sale->status }}","time":"{{ $sale->created_at->diffForHumans() }}"}' />
                                    </div>
                                </td>
                                <td class="align-middle id white-space-nowrap">
                                    <h6 class="mb-0 text-body-highlight">#{{ $sale->id }}</h6>
                                </td>
                                <td class="align-middle customer white-space-nowrap">
                                    <a class="d-flex align-items-center text-body" href="#!">
                                        <div class="avatar avatar-l">
                                            @if($waiter->avatar)
                                                <img class="rounded-circle" src="{{ asset($waiter->avatar) }}" alt="" />
                                            @else
                                                <div class="avatar-name rounded-circle">
                                                    <span>{{ substr($waiter->name, 0, 1) }}</span>
                                                </div>
                                            @endif
                                        </div>
                                        <h6 class="mb-0 ms-3 text-body">{{ $waiter->name }}</h6>
                                    </a>
                                </td>
                                <td class="align-middle cashier white-space-nowrap">
                                    <span class="text-body">{{ $sale->cashier->name ?? 'System' }}</span>
                                </td>
                                <td class="align-middle amount white-space-nowrap">
                                    <h6 class="mb-0 text-body-highlight">Tsh. {{ number_format($sale->total, 0) }}</h6>
                                </td>
                                <td class="align-middle payment white-space-nowrap">
                                    <span class="badge fs-10 badge-phoenix 
                                        @if($sale->payment_type === 'Cash') badge-phoenix-primary
                                        @elseif($sale->payment_type === 'Mobile') badge-phoenix-info
                                        @else badge-phoenix-secondary @endif">
                                        <span class="badge-label">{{ $sale->payment_type }}</span>
                                    </span>
                                </td>
                                <td class="align-middle items" style="min-width:200px;">
                                    <p class="fs-9 fw-semibold text-body-highlight mb-0">
                                        {{ $sale->items->count() }} items
                                        @if($sale->items->count() > 0)
                                        <br><small class="text-muted">{{ $sale->items->first()->product->product_name ?? 'Item' }}{{ $sale->items->count() > 1 ? ' +' . ($sale->items->count() - 1) . ' more' : '' }}</small>
                                        @endif
                                    </p>
                                </td>
                                <td class="align-middle text-start ps-5 status">
                                    @if($sale->status === 'verified')
                                        <span class="badge badge-phoenix fs-10 badge-phoenix-success">
                                            <span class="badge-label">Verified</span>
                                            <span class="ms-1" data-feather="check" style="height:12.8px;width:12.8px;"></span>
                                        </span>
                                    @else
                                        <span class="badge badge-phoenix fs-10 badge-phoenix-warning">
                                            <span class="badge-label">Pending</span>
                                            <span class="ms-1" data-feather="clock" style="height:12.8px;width:12.8px;"></span>
                                        </span>
                                    @endif
                                </td>
                                <td class="align-middle text-end time white-space-nowrap">
                                    <div>
                                        <h6 class="text-body-highlight mb-0">{{ $sale->created_at->format('H:i') }}</h6>
                                        <small class="text-muted">{{ $sale->created_at->format('M d, Y') }}</small>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="row align-items-center py-1">
                    <div class="pagination d-none"></div>
                    <div class="col d-flex fs-9">
                        <p class="mb-0 d-none d-sm-block me-3 fw-semibold text-body" data-list-info="data-list-info"></p>
                        <a class="fw-semibold" href="#!" data-list-view="*">View all<span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span></a>
                        <a class="fw-semibold d-none" href="#!" data-list-view="less">View Less</a>
                    </div>
                    <div class="col-auto d-flex">
                        <button class="btn btn-link px-1 me-1" type="button" title="Previous" data-list-pagination="prev">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                        <button class="btn btn-link px-1 ms-1" type="button" title="Next" data-list-pagination="next">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.avatar-name {
    display: flex;
    align-items: center;
    justify-content: center;
}
.nav-tabs .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
}
.nav-tabs .nav-link.active {
    color: #007bff;
    border-bottom: 2px solid #007bff;
    background: transparent;
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Initialize Feather icons
    if (typeof feather !== 'undefined') {
        feather.replace();
    }
});
</script>
@endpush