@extends('layouts.admin')

@section('title', 'Waiter Dashboard')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="fw-bold py-3 mb-2">
                <span class="text-muted fw-light">Waiter /</span> Dashboard
            </h4>
            <p class="text-body-tertiary">Welcome back, {{ ucwords(Auth::user()->name) }}! Here's your performance overview.</p>
        </div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Today's Sales</h5>
                            <h2 class="mb-0 text-primary">Tsh. {{ number_format($waiterStats['today_sales'] ?? 0, 2) }}</h2>
                            <p class="fs-9 mb-0 {{ ($waiterStats['sales_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                <span class="fas fa-arrow-{{ ($waiterStats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                {{ number_format($waiterStats['sales_growth'] ?? 0, 1) }}% from yesterday
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Items Sold Today</h5>
                            <h2 class="mb-0 text-info">{{ $waiterStats['today_items_sold'] ?? 0 }}</h2>
                            <p class="fs-9 mb-0 {{ ($waiterStats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                <span class="fas fa-arrow-{{ ($waiterStats['items_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                {{ number_format($waiterStats['items_growth'] ?? 0, 1) }}% from yesterday
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Today's Transactions</h5>
                            <h2 class="mb-0 text-success">{{ $waiterStats['today_transactions'] ?? 0 }}</h2>
                            <p class="fs-9 mb-0 {{ ($waiterStats['transactions_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                <span class="fas fa-arrow-{{ ($waiterStats['transactions_growth'] ?? 0) >= 0 ? 'up' : 'down' }} me-1"></span>
                                {{ number_format($waiterStats['transactions_growth'] ?? 0, 1) }}% from yesterday
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Avg. Sale Value</h5>
                            <h2 class="mb-0 text-warning">Tsh. {{ number_format($waiterStats['average_sale_value'] ?? 0, 2) }}</h2>
                            <p class="fs-9 mb-0">Per transaction today</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-12 col-xxl-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">My Performance: Today vs Yesterday</h5>
                    <small class="text-body-tertiary">Hourly sales comparison (7:00 - 22:00)</small>
                </div>
                <div class="card-body">
                    <div class="echart-waiter-performance" style="height: 350px;"></div>
                </div>
            </div>
        </div>

        <div class="col-12 col-xxl-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">This Week's Performance</h5>
                    <small class="text-body-tertiary">Daily sales breakdown</small>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless">
                            <thead>
                                <tr>
                                    <th class="small fw-semibold text-body-tertiary">Day</th>
                                    <th class="text-end small fw-semibold text-body-tertiary">Sales</th>
                                    <th class="text-end small fw-semibold text-body-tertiary">Transactions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($weeklyPerformance as $day)
                                <tr>
                                    <td class="small">{{ $day['day'] }}</td>
                                    <td class="text-end fw-semibold">Tsh {{ number_format($day['sales'], 0) }}</td>
                                    <td class="text-end">
                                        <span class="badge badge-phoenix fs-10 badge-phoenix-primary">
                                            {{ $day['transactions'] }} sales
                                        </span>
                                    </td>
                                </tr>
                                @endforeach
                                <tr class="border-top">
                                    <td class="fw-bold">Total</td>
                                    <td class="text-end fw-bold text-primary">Tsh {{ number_format($weeklyPerformance->sum('sales'), 0) }}</td>
                                    <td class="text-end fw-bold">{{ $weeklyPerformance->sum('transactions') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4 pt-3 border-top">
                        <div class="row text-center">
                            <div class="col-6 border-end">
                                <h6 class="mb-1 text-success">Best Day</h6>
                                <p class="fw-bold mb-0">{{ $bestDay['day'] ?? 'N/A' }}</p>
                                <small class="text-muted">Tsh {{ number_format($bestDay['sales'] ?? 0, 0) }}</small>
                            </div>
                            <div class="col-6">
                                <h6 class="mb-1 text-info">Avg. Daily</h6>
                                <p class="fw-bold mb-0">Tsh {{ number_format($weeklyPerformance->avg('sales'), 0) }}</p>
                                <small class="text-muted">{{ round($weeklyPerformance->avg('transactions'), 1) }} sales</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-12 col-xxl-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0">Today's Sales</h5>
                        <small class="text-body-tertiary">All sales served by you today</small>
                    </div>
                    <div class="badge bg-primary rounded-pill">{{ $todaySales->count() }} Sales</div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-body-secondary">
                                <tr>
                                    <th class="ps-4 small fw-semibold text-body-tertiary">Sale ID</th>
                                    <th class="small fw-semibold text-body-tertiary">Time</th>
                                    <th class="small fw-semibold text-body-tertiary">Items</th>
                                    <th class="small fw-semibold text-body-tertiary">Amount</th>
                                    <th class="small fw-semibold text-body-tertiary">Payment</th>
                                    <th class="small fw-semibold text-body-tertiary">Status</th>
                                    <th class="pe-4 small fw-semibold text-body-tertiary">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($todaySales as $sale)
                                <tr class="border-bottom">
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
<span class="badge bg-primary rounded-pill px-3 py-2 fs-10">
    #{{ $sale->id }}
</span>

                                            <div class="mb-0 px-2 text-nowrap">
                                                <h6 class="mb-0 px-2 fw-semibold">Sale #{{ $sale->id }}</h6>
                                                <small class="text-muted px-2">{{ $sale->items->count() }} items</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-semibold">{{ $sale->created_at->format('H:i') }}</span>
                                            <small class="text-muted">{{ $sale->created_at->format('M d') }}</small>
                                        </div>
                                    </td>
                                    <td>
<small class="text-body-highlight">
    @if($sale->items->count() > 0)
        {{-- Show first item --}}
        {{ $sale->items->first()->product->product_name ?? 'Item' }}

        @if($sale->items->count() == 2)
            {{-- Show second item directly if only 2 --}}
            , {{ $sale->items->skip(1)->first()->product->product_name ?? 'Item' }}
        @elseif($sale->items->count() > 2)
            {{-- Show second item and count the rest --}}
            , {{ $sale->items->skip(1)->first()->product->product_name ?? 'Item' }}
            +{{ $sale->items->count() - 2 }} more
        @endif
    @else
        No items
    @endif
</small>

                                    </td>
                                    <td>
                                        <span class="fw-bold text-success">Tsh {{ number_format($sale->total, 2) }}</span>
                                    </td>
                                    <td>
                                        <span class="badge fs-10 badge-phoenix 
                                            @if($sale->payment_type === 'Cash') badge-phoenix-primary
                                            @elseif($sale->payment_type === 'Mobile') badge-phoenix-info
                                            @else badge-phoenix-secondary @endif">
                                            <span class="badge-label">{{ $sale->payment_type }}</span>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-phoenix fs-10 badge-phoenix-{{ $sale->status === 'verified' ? 'success' : 'warning' }}">
                                            <span class="badge-label">{{ ucfirst($sale->status) }}</span>
                                            <span class="ms-1 fas fa-{{ $sale->status === 'verified' ? 'check' : 'clock' }}"></span>
                                        </span>
                                    </td>
                                    <td class="pe-4">
                                        <div class="d-flex gap-2">
                                            <a href="{{ url('sales/receipt/'.$sale->id) }}" 
                                               class="btn btn-sm btn-phoenix-primary"
                                               target="_blank"
                                               title="View Receipt">
                                                <span class="fas fa-eye fs-10"></span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-5">
                                        <i class="fas fa-receipt text-muted fa-2x mb-3"></i>
                                        <p class="text-muted mb-0">No sales served today</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Monthly Performance Overview</h5>
                    <small class="text-body-tertiary">Your sales performance for the current month</small>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-12 col-md-6 col-lg-3">
                            <div class="text-center">
                                <h3 class="text-primary mb-1">Tsh {{ number_format($monthlyStats['total_sales'] ?? 0, 0) }}</h3>
                                <p class="text-muted mb-0">Total Sales</p>
                                <small class="text-success">
                                    <i class="fas fa-arrow-up me-1"></i>
                                    {{ number_format($monthlyStats['sales_growth'] ?? 0, 1) }}% vs last month
                                </small>
                            </div>
                        </div>
                        <div class="col-12 col-md-6 col-lg-3">
                            <div class="text-center">
                                <h3 class="text-info mb-1">{{ $monthlyStats['total_transactions'] ?? 0 }}</h3>
                                <p class="text-muted mb-0">Total Transactions</p>
                                <small class="text-success">
                                    <i class="fas fa-arrow-up me-1"></i>
                                    {{ number_format($monthlyStats['transactions_growth'] ?? 0, 1) }}% vs last month
                                </small>
                            </div>
                        </div>
                        <div class="col-12 col-md-6 col-lg-3">
                            <div class="text-center">
                                <h3 class="text-success mb-1">{{ $monthlyStats['total_items'] ?? 0 }}</h3>
                                <p class="text-muted mb-0">Items Sold</p>
                                <small class="text-success">
                                    <i class="fas fa-arrow-up me-1"></i>
                                    {{ number_format($monthlyStats['items_growth'] ?? 0, 1) }}% vs last month
                                </small>
                            </div>
                        </div>
                        <div class="col-12 col-md-6 col-lg-3">
                            <div class="text-center">
                                <h3 class="text-warning mb-1">Tsh {{ number_format($monthlyStats['average_sale'] ?? 0, 0) }}</h3>
                                <p class="text-muted mb-0">Avg. Sale Value</p>
                                <small class="text-body-tertiary">This month</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-4 pt-3">
                        <h6 class="mb-3">Weekly Progress This Month</h6>
                        <div class="row g-2">
                            @foreach($monthlyWeeklyProgress as $week)
                            <div class="col-12 col-sm-6 col-lg-3">
                                <div class="card bg-body-tertiary">
                                    <div class="card-body py-2">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span class="fw-semibold">{{ $week['week'] }}</span>
                                            <span class="badge bg-primary rounded-pill">Tsh {{ number_format($week['sales'], 0) }}</span>
                                        </div>
                                        <small class="text-muted">{{ $week['transactions'] }} sales</small>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Pass PHP data to JavaScript
window.waiterChartData = @json($waiterChartData ?? []);
window.waiterStats = @json($waiterStats ?? []);

document.addEventListener("DOMContentLoaded", function() {
    // Initialize waiter performance chart
    initializeWaiterCharts();
});

function initializeWaiterCharts() {
    // Waiter Performance Chart - Today vs Yesterday
    if (window.waiterChartData.today_vs_yesterday && window.echarts) {
        const chartEl = document.querySelector('.echart-waiter-performance');
        if (chartEl) {
            const chart = echarts.init(chartEl);
            const option = {
                color: ['#007bff', '#6c757d'],
                tooltip: {
                    trigger: 'axis',
                    formatter: function(params) {
                        return `<strong>${params[0].name}</strong><br/>
                                ${params[0].seriesName}: <span style="color: #007bff; font-weight: bold;">Tsh ${params[0].value.toLocaleString()}</span><br/>
                                ${params[1].seriesName}: <span style="color: #6c757d; font-weight: bold;">Tsh ${params[1].value.toLocaleString()}</span>`;
                    }
                },
                legend: {
                    data: ['Today', 'Yesterday'],
                    top: 10
                },
                grid: {
                    left: '3%',
                    right: '4%',
                    bottom: '3%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: window.waiterChartData.today_vs_yesterday.labels
                },
                yAxis: {
                    type: 'value',
                    axisLabel: {
                        formatter: 'Tsh {value}'
                    }
                },
                series: [
                    {
                        name: 'Today',
                        type: 'line',
                        data: window.waiterChartData.today_vs_yesterday.today_sales,
                        smooth: false,
                        lineStyle: {
                            width: 1
                        },
                        itemStyle: {
                            color: '#007bff'
                        }
                    },
                    {
                        name: 'Yesterday',
                        type: 'line',
                        data: window.waiterChartData.today_vs_yesterday.yesterday_sales,
                        smooth: false,
                        lineStyle: {
                            width: 1,
                            type: 'dashed'
                        },
                        itemStyle: {
                            color: '#6c757d'
                        }
                    }
                ]
            };
            chart.setOption(option);
        }
    }
}
</script>
@endpush