
<!-- ===============================================-->
<!--    Favicons-->
<!-- ===============================================-->
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/favicons/apple-touch-icon.png')); ?>">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/img/favicons/drestaurant.png')); ?>">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/img/favicons/drestaurant.png')); ?>">
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('assets/img/favicons/drestaurant.png')); ?>">
<link rel="manifest" href="<?php echo e(asset('assets/img/favicons/manifest.json')); ?>">
<meta name="msapplication-TileImage" content="<?php echo e(asset('assets/img/favicons/mstile-150x150.png')); ?>">
<meta name="theme-color" content="#ffffff">
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


<!-- ===============================================-->
<!--    Stylesheets-->
<!-- ===============================================-->
<link rel="preconnect" href="https://fonts.googleapis.com/">
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.jsdelivr.net/npm/echarts/dist/echarts.min.js"></script>
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@300;400;600;700;800;900&display=swap" rel="stylesheet">
<link href="<?php echo e(asset('vendors/simplebar/simplebar.min.css')); ?>" rel="stylesheet">
<link rel="stylesheet" href="https://unicons.iconscout.com/release/v4.0.8/css/line.css">
<link href="<?php echo e(asset('assets/css/theme-rtl.min.css')); ?>" type="text/css" rel="stylesheet" id="style-rtl">
<link href="<?php echo e(asset('assets/css/theme.min.css')); ?>" type="text/css" rel="stylesheet" id="style-default">
<link href="<?php echo e(asset('assets/css/user-rtl.min.css')); ?>" type="text/css" rel="stylesheet" id="user-style-rtl">
<link href="<?php echo e(asset('assets/css/user.min.css')); ?>" type="text/css" rel="stylesheet" id="user-style-default">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!-- Scripts needed in head -->
<script src="<?php echo e(asset('vendors/simplebar/simplebar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
<link href="<?php echo e(asset('assets/vendors/leaflet/leaflet.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/vendors/leaflet.markercluster/MarkerCluster.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/vendors/leaflet.markercluster/MarkerCluster.Default.css')); ?>" rel="stylesheet">

<style>
#loader {
  position: fixed;
  z-index: 9999;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: white;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
}

.loader-content {
  text-align: center;
}

.spinner {
  border: 6px solid #eee;
  border-top: 6px solid #007bff;
  border-radius: 50%;
  width: 70px;
  height: 70px;
  margin-bottom: 15px;
  animation: spin 1s linear infinite;
}

#loading-text {
  font-size: 22px;
  font-weight: bold;
  color: #007bff;
  font-family: 'Montserrat', sans-serif;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

#content {
  opacity: 0;
  transition: opacity 0.5s ease;
}

body.loaded #content {
  opacity: 1;
}

body.loaded #loader {
  display: none;
}

</style>
           <script>
      var phoenixIsRTL = window.config.config.phoenixIsRTL;
      if (phoenixIsRTL) {
        var linkDefault = document.getElementById('style-default');
        var userLinkDefault = document.getElementById('user-style-default');
        linkDefault.setAttribute('disabled', true);
        userLinkDefault.setAttribute('disabled', true);
        document.querySelector('html').setAttribute('dir', 'rtl');
      } else {
        var linkRTL = document.getElementById('style-rtl');
        var userLinkRTL = document.getElementById('user-style-rtl');
        linkRTL.setAttribute('disabled', true);
        userLinkRTL.setAttribute('disabled', true);
      }





      // Initialize all charts
function initializeAllCharts() {
    initializeTodayYesterdayChart();
    initializeWeekComparisonChart();
    initializeMonthComparisonChart();
    initializeYearComparisonChart();
}

// Chart 1: Today vs Yesterday
function initializeTodayYesterdayChart() {
    const chartElement = document.querySelector('.echart-today-yesterday');
    if (!chartElement) return;

    const data = window.chartData.today_vs_yesterday;
    const chart = echarts.init(chartElement);
    
    const option = {
        tooltip: {
            trigger: 'axis',
            formatter: function(params) {
                let tooltip = `<div class="text-center">`;
                params.forEach(param => {
                    const label = param.seriesName === 'today' ? 'Today' : 'Yesterday';
                    tooltip += `<div>${label}: ₹${param.value}</div>`;
                });
                tooltip += `</div>`;
                return tooltip;
            }
        },
        legend: {
            data: ['Today', 'Yesterday']
        },
        xAxis: {
            type: 'category',
            data: data.labels
        },
        yAxis: {
            type: 'value',
            axisLabel: {
                formatter: '₹{value}'
            }
        },
        series: [
            {
                name: 'today',
                type: 'line',
                data: data.today_sales,
                smooth: true,
                lineStyle: { width: 3 }
            },
            {
                name: 'yesterday',
                type: 'line',
                data: data.yesterday_sales,
                smooth: true,
                lineStyle: { 
                    width: 3,
                    type: 'dashed'
                }
            }
        ]
    };
    
    chart.setOption(option);
}

// Similar functions for other charts (initializeWeekComparisonChart, etc.)
// ... implement similar patterns for other charts

// Refresh chart data via AJAX
function refreshChartData(chartType) {
    fetch(`/api/chart-data?type=${chartType}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update the specific chart with new data
                updateChart(chartType, data.data);
            }
        })
        .catch(error => console.error('Error fetching chart data:', error));
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
    initializeAllCharts();
    
    // Optional: Auto-refresh every 5 minutes
    setInterval(() => {
        refreshChartData('today_vs_yesterday');
    }, 30000);
});
    </script>
    <?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/includes/head.blade.php ENDPATH**/ ?>