<!-- resources/views/includes/scripts.blade.php -->

<!-- ===============================================-->
<!--    JavaScripts-->
<!-- ===============================================-->
 <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="<?php echo e(asset('vendors/popper/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/bootstrap/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/anchorjs/anchor.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/is/is.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/fontawesome/all.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/lodash/lodash.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/list.js/list.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/feather-icons/feather.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/dayjs/dayjs.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/leaflet/leaflet.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/leaflet.markercluster/leaflet.markercluster.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/leaflet.tilelayer.colorfilter/leaflet-tilelayer-colorfilter.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/phoenix.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/echarts/echarts.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/dashboards/ecommerce-dashboard.js')); ?>"></script>
<?php $__env->startPush('scripts'); ?>
<!-- jQuery (needed for your $.ajax) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let inactivityTimer;
const inactivityLimit = 0.2* 60 * 1000; // 12 secs in ms

function resetInactivityTimer() {
    clearTimeout(inactivityTimer);
    inactivityTimer = setTimeout(logoutUser, inactivityLimit);
}

function logoutUser() {
    // Call Laravel logout route
    fetch("<?php echo e(url('logout')); ?>", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
            "Content-Type": "application/json"
        },
        
    })
    .then(() => {
        // redirect to login page
        window.location.href = "<?php echo e(url('/')); ?>";
    })
    .catch(() => {
        // fallback redirect if fetch fails
        window.location.href = "<?php echo e(url('/')); ?>";
    });
}

// Reset timer on any user activity
window.onload = resetInactivityTimer;
document.onmousemove = resetInactivityTimer;
document.onkeypress = resetInactivityTimer;
document.onclick = resetInactivityTimer;
document.onscroll = resetInactivityTimer;
</script>

<script>
    // Set CSRF token for all AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Auto-refresh CSRF token every 5 minutes
    setInterval(() => {
        $.get('/refresh-csrf').done(function(data) {
            $('meta[name="csrf-token"]').attr('content', data.token);
        });
    }, 0.5 * 60 * 1000); // every 1/2 minutes
</script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css"/>
<script>
    const totalSalesChartInit = () => {
  const { getColor: o, getData: t, getDates: e } = window.phoenix.utils;
  const a = document.querySelector(".echart-total-sales-chart");
  
  // Generate time labels from 7:00 to 22:00 (hourly)
  const generateTimeLabels = () => {
    const labels = [];
    for (let hour = 7; hour <= 22; hour++) {
      labels.push(`${hour.toString().padStart(2, '0')}:00`);
    }
    return labels;
  };
  
  const i = generateTimeLabels(); // Time labels from 07:00 to 22:00
  
  // Get sales data from the server (will be populated by controller)
  const salesData = window.salesChartData || {
    hourly_sales: Array(16).fill(0), // 7:00-22:00 = 16 hours
    hourly_orders: Array(16).fill(0)
  };
  
  const n = salesData.hourly_sales; // Sales amounts per hour
  const s = salesData.hourly_orders; // Number of orders per hour
  
  const r = params => {
    const time = params[0].axisValue; // This will be the time label (e.g., "07:00")
    const hour = parseInt(time.split(':')[0]);
    const dataPoints = params.map((param, index) => ({ 
      value: param.value, 
      time: time,
      period: index > 0 ? `${hour-1}:00-${hour}:00` : `${hour}:00-${hour+1}:00`,
      color: param.color,
      seriesIndex: index
    }));
    
    let html = "";
    dataPoints.forEach((data, index) => {
      html += `<h6 class="fs-9 text-body-tertiary ${index > 0 && "mb-0"}">
        <span class="fas fa-circle me-2" style="color:${data.color}"></span>
        ${data.period} : ${data.seriesIndex > 0 ? data.value + ' orders' : '₹' + data.value}
      </h6>`;
    });
    
    return `<div class='ms-1'>${html}</div>`;
  };
  
  if (a) {
    const e = t(a, "echarts");
    const l = window.echarts.init(a);
    
    echartSetOption(l, e, () => ({
      color: [o("primary"), o("info")],
      tooltip: {
        trigger: "axis",
        padding: 10,
        backgroundColor: o("body-highlight-bg"),
        borderColor: o("border-color"),
        textStyle: { color: o("light-text-emphasis") },
        borderWidth: 1,
        transitionDuration: 0,
        axisPointer: { type: "none", z: 0 },
        formatter: r,
        extraCssText: "z-index: 1000"
      },
      xAxis: [{
        type: "category",
        data: i,
        axisLabel: {
          formatter: time => time, // Display time as is (e.g., "07:00")
          interval: 2, // Show every 2 hours for better readability
          showMinLabel: true,
          showMaxLabel: false,
          color: o("secondary-color"),
          align: "left",
          fontFamily: "Nunito Sans",
          fontWeight: 600,
          fontSize: 12.8
        },
        axisLine: { show: true, lineStyle: { color: o("secondary-bg") } },
        axisTick: { show: false },
        splitLine: {
          show: true,
          interval: 0,
          lineStyle: { color: window.config.config.phoenixTheme === "dark" ? o("body-highlight-bg") : o("secondary-bg") }
        },
        boundaryGap: false
      }, {
        type: "category",
        position: "bottom",
        data: i,
        axisLabel: {
          formatter: time => time,
          interval: 15, // Show only first and last for second axis
          showMaxLabel: true,
          showMinLabel: false,
          color: o("secondary-color"),
          align: "right",
          fontFamily: "Nunito Sans",
          fontWeight: 600,
          fontSize: 12.8
        },
        axisLine: { show: false },
        axisTick: { show: false },
        splitLine: { show: false },
        boundaryGap: false
      }],
      yAxis: [{
        position: "left",
        type: "value",
        name: "Sales (Tshs)",
        nameTextStyle: { color: o("secondary-color") },
        axisPointer: { type: "none" },
        axisTick: "none",
        splitLine: { 
          show: true,
          lineStyle: { color: o("secondary-bg"), type: "dashed" }
        },
        axisLine: { show: false },
        axisLabel: { 
          show: true,
          color: o("secondary-color"),
          formatter: '{value}'
        }
      }, {
        position: "right",
        type: "value",
        name: "Orders",
        nameTextStyle: { color: o("info") },
        axisPointer: { type: "none" },
        axisTick: "none",
        splitLine: { show: false },
        axisLine: { show: false },
        axisLabel: { 
          show: true,
          color: o("info"),
          formatter: '{value}'
        }
      }],
      series: [{
        name: "Sales",
        type: "line",
        data: n,
        showSymbol: true,
        symbol: "circle",
        symbolSize: 6,
        yAxisIndex: 0,
        lineStyle: { width: 3, color: o("primary") },
        itemStyle: { color: o("primary") },
        zlevel: 2
      }, {
        name: "Orders",
        type: "line",
        data: s,
        yAxisIndex: 1,
        showSymbol: true,
        symbol: "circle",
        symbolSize: 6,
        lineStyle: { type: "dashed", width: 2, color: o("info") },
        itemStyle: { color: o("info") },
        zlevel: 1
      }],
      grid: { right: 60, left: 60, bottom: "20px", top: "15%", containLabel: true },
      animation: false,
      legend: {
        data: ['Sales', 'Orders'],
        top: 0,
        textStyle: { color: o("secondary-color") }
      }
    }));
  }
};

// Initialize chart when DOM is ready
document.addEventListener("DOMContentLoaded", function() {
  totalSalesChartInit();
});
</script><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/includes/scripts.blade.php ENDPATH**/ ?>