<?php $__env->startSection('title', 'Sales Analytics Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="fw-bold py-3 mb-2">
                <span class="text-muted fw-light">Analytics /</span> Sales Reports
            </h4>
            <p class="text-body-tertiary">Comprehensive sales analytics and performance reports</p>
        </div>
    </div>

    <!-- Summary Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex align-items-center gap-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-primary">
                                    <i class="fas fa-receipt fa-lg"></i>
                                </span>
                            </div>
                            <div class="card-info">
                                <h5 class="mb-0">Tsh <?php echo e(number_format($summaryStats['total_sales'], 2)); ?></h5>
                                <small>Total Sales</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex align-items-center gap-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-success">
                                    <i class="fas fa-shopping-cart fa-lg"></i>
                                </span>
                            </div>
                            <div class="card-info">
                                <h5 class="mb-0"><?php echo e($summaryStats['total_orders']); ?></h5>
                                <small>Total Orders</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex align-items-center gap-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-info">
                                    <i class="fas fa-chart-line fa-lg"></i>
                                </span>
                            </div>
                            <div class="card-info">
                                <h5 class="mb-0">Tsh <?php echo e(number_format($summaryStats['average_order_value'], 2)); ?></h5>
                                <small>Avg Order Value</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex align-items-center gap-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-warning">
                                    <i class="fas fa-percentage fa-lg"></i>
                                </span>
                            </div>
                            <div class="card-info">
                                <h5 class="mb-0">Tsh <?php echo e(number_format($summaryStats['total_tax'], 2)); ?></h5>
                                <small>Total Tax</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Filters Card -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <h5 class="mb-0">Report Filters</h5>
            <div class="d-flex gap-2 flex-wrap">
                <button class="btn btn-success" onclick="exportData('excel')">
                    <i class="fas fa-file-excel me-1"></i>Export Excel
                </button>
                <button class="btn btn-danger" onclick="exportData('pdf')">
                    <i class="fas fa-file-pdf me-1"></i>Export PDF
                </button>
                <button class="btn btn-secondary" onclick="exportData('csv')">
                    <i class="fas fa-file-csv me-1"></i>Export CSV
                </button>
            </div>
        </div>

        <div class="card-body">
            <form method="GET" action="<?php echo e(route('sales.report')); ?>" class="row g-3 align-items-end" id="filterForm">
                <input type="hidden" name="tab" value="<?php echo e($activeTab); ?>" id="activeTab">
                
                <!-- Quick Date Range -->
                <div class="col-md-3">
                    <label class="form-label">Quick Date Range</label>
                    <select name="date_range" class="form-select" id="dateRangeSelect">
                        <option value="today" <?php echo e(request('date_range') == 'today' ? 'selected' : ''); ?>>Today</option>
                        <option value="yesterday" <?php echo e(request('date_range') == 'yesterday' ? 'selected' : ''); ?>>Yesterday</option>
                        <option value="this_week" <?php echo e(request('date_range') == 'this_week' ? 'selected' : ''); ?>>This Week</option>
                        <option value="last_week" <?php echo e(request('date_range') == 'last_week' ? 'selected' : ''); ?>>Last Week</option>
                        <option value="this_month" <?php echo e(request('date_range') == 'this_month' ? 'selected' : ''); ?>>This Month</option>
                        <option value="last_month" <?php echo e(request('date_range') == 'last_month' ? 'selected' : ''); ?>>Last Month</option>
                        <option value="last_3_months" <?php echo e(request('date_range') == 'last_3_months' ? 'selected' : ''); ?>>Last 3 Months</option>
                        <option value="this_year" <?php echo e(request('date_range') == 'this_year' ? 'selected' : ''); ?>>This Year</option>
                        <option value="custom" <?php echo e(request('date_range') == 'custom' ? 'selected' : ''); ?>>Custom Range</option>
                    </select>
                </div>

                <!-- Custom Date Range -->
                <div class="col-md-2">
                    <label class="form-label">From</label>
                    <input type="date" name="from" class="form-control" value="<?php echo e(request('from')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To</label>
                    <input type="date" name="to" class="form-control" value="<?php echo e(request('to')); ?>">
                </div>

                <!-- Other Filters -->
                <div class="col-md-2">
                    <label class="form-label">Waiter</label>
                    <select name="waiter_id" class="form-select">
                        <option value="">All Waiters</option>
                        <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($waiter->id); ?>" <?php echo e(request('waiter_id') == $waiter->id ? 'selected' : ''); ?>>
                                <?php echo e(ucwords($waiter->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Cashier</label>
                    <select name="cashier_id" class="form-select">
                        <option value="">All Cashiers</option>
                        <?php $__currentLoopData = $cashiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cashier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cashier->id); ?>" <?php echo e(request('cashier_id') == $cashier->id ? 'selected' : ''); ?>>
                                <?php echo e(ucwords($cashier->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Type</label>
                    <select name="payment_type" class="form-select">
                        <option value="">All Payments</option>
                        <option value="Cash" <?php echo e(request('payment_type') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
                        <option value="Mobile" <?php echo e(request('payment_type') == 'Mobile' ? 'selected' : ''); ?>>Mobile</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="verified" <?php echo e(request('status') == 'verified' ? 'selected' : ''); ?>>Verified</option>
                    </select>
                </div>
                <div class="col-md-12 text-end mt-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-filter me-1"></i> Apply Filters
                    </button>
                    <a href="<?php echo e(route('sales.report')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-redo me-1"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Tabs -->
    <div class="card">
        <div class="card-header">
            <ul class="nav nav-tabs card-header-tabs" id="reportTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'detailed' ? 'active' : ''); ?>" 
                       href="#" data-tab="detailed">
                        <i class="fas fa-list me-1"></i> Detailed Sales
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'daily' ? 'active' : ''); ?>" 
                       href="#" data-tab="daily">
                        <i class="fas fa-calendar-day me-1"></i> Daily Summary
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'weekly' ? 'active' : ''); ?>" 
                       href="#" data-tab="weekly">
                        <i class="fas fa-calendar-week me-1"></i> Weekly Summary
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'monthly' ? 'active' : ''); ?>" 
                       href="#" data-tab="monthly">
                        <i class="fas fa-calendar-alt me-1"></i> Monthly Summary
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'products' ? 'active' : ''); ?>" 
                       href="#" data-tab="products">
                        <i class="fas fa-cube me-1"></i> Product Performance
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'waiters' ? 'active' : ''); ?>" 
                       href="#" data-tab="waiters">
                        <i class="fas fa-users me-1"></i> Waiter Performance
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($activeTab == 'hourly' ? 'active' : ''); ?>" 
                       href="#" data-tab="hourly">
                        <i class="fas fa-clock me-1"></i> Hourly Analysis
                    </a>
                </li>
            </ul>
        </div>

        <div class="card-body p-0">
            <!-- Detailed Sales Tab -->
            <div class="tab-pane <?php echo e($activeTab == 'detailed' ? 'active' : ''); ?>" id="detailedTab">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0">Detailed Sales Transactions</h5>
                        <small class="text-body-tertiary">All sales records with detailed information</small>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <div class="badge bg-primary rounded-pill"><?php echo e($detailedSales->count()); ?> Sales</div>
                        <div class="text-body-tertiary small">
                            Total: Tsh <?php echo e(number_format($detailedTotals['total'], 2)); ?>

                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-body-secondary">
                            <tr>
                                <th class="ps-4 small fw-semibold text-body-tertiary">Sale ID</th>
                                <th class="small fw-semibold text-body-tertiary">Date & Time</th>
                                <th class="small fw-semibold text-body-tertiary">Waiter</th>
                                <th class="small fw-semibold text-body-tertiary">Cashier</th>
                                <th class="small fw-semibold text-body-tertiary">Subtotal</th>
                                <th class="small fw-semibold text-body-tertiary">Tax</th>
                                <th class="small fw-semibold text-body-tertiary">Total</th>
                                <th class="small fw-semibold text-body-tertiary">Payment</th>
                                <th class="small fw-semibold text-body-tertiary">Status</th>
                                <th class="pe-4 small fw-semibold text-body-tertiary">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $detailedSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-bottom">
                                <td class="ps-4">
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-primary rounded-pill px-3 py-2 fs-10">
                                            #<?php echo e($sale->id); ?>

                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        <span class="fw-semibold"><?php echo e($sale->created_at->format('H:i')); ?></span>
                                        <small class="text-muted"><?php echo e($sale->created_at->format('M d, Y')); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <span class="fw-semibold"><?php echo e($sale->waiter ? ucwords($sale->waiter->name) : '—'); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold"><?php echo e($sale->cashier ? ucwords($sale->cashier->name) : '—'); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format(floatval($sale->subtotal), 2)); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format(floatval($sale->tax), 2)); ?></span>
                                </td>
                                <td>
                                    <span class="fw-bold text-success">Tsh <?php echo e(number_format($sale->total, 2)); ?></span>
                                </td>
                                <td>
                                    <span class="badge fs-10 badge-phoenix 
                                        <?php if($sale->payment_type === 'Cash'): ?> badge-phoenix-primary
                                        <?php elseif($sale->payment_type === 'Mobile'): ?> badge-phoenix-info
                                        <?php else: ?> badge-phoenix-secondary <?php endif; ?>">
                                        <span class="badge-label"><?php echo e($sale->payment_type); ?></span>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($sale->status === 'verified' ? 'success' : 'warning'); ?>">
                                        <span class="badge-label"><?php echo e(ucfirst($sale->status)); ?></span>
                                        <span class="ms-1 fas fa-<?php echo e($sale->status === 'verified' ? 'check' : 'clock'); ?>"></span>
                                    </span>
                                </td>
                                <td class="pe-4">
                                    <div class="d-flex gap-2">
                                        <a href="<?php echo e(url('sales/receipt/'.$sale->id)); ?>" 
                                           class="btn btn-sm btn-phoenix-primary"
                                           target="_blank"
                                           title="View Receipt">
                                            <span class="fas fa-eye fs-10"></span>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-2x mb-2"></i>
                                        <p>No sales records found for the selected filters</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <!-- Pagination for Detailed Sales -->
                <?php if($detailedSales->hasPages()): ?>
                <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
                    <div class="row align-items-center justify-content-between g-3">
                        <div class="col-auto">
                            <p class="mb-0 fs-9 text-body-tertiary">
                                <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                                    Showing <?php echo e(($detailedSales->currentPage() - 1) * $detailedSales->perPage() + 1); ?> to 
                                    <?php echo e(min($detailedSales->currentPage() * $detailedSales->perPage(), $detailedSales->total())); ?> of 
                                    <?php echo e($detailedSales->total()); ?> entries
                                </span>
                            </p>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-2">
                                <?php if($detailedSales->onFirstPage()): ?>
                                    <button class="btn btn-sm btn-phoenix-secondary" disabled>
                                        <span class="fas fa-chevron-left me-2"></span>Previous
                                    </button>
                                <?php else: ?>
                                    <a href="<?php echo e($detailedSales->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                                        <span class="fas fa-chevron-left me-2"></span>Previous
                                    </a>
                                <?php endif; ?>

                                <?php if($detailedSales->hasMorePages()): ?>
                                    <a href="<?php echo e($detailedSales->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                                        Next<span class="fas fa-chevron-right ms-2"></span>
                                    </a>
                                <?php else: ?>
                                    <button class="btn btn-sm btn-phoenix-secondary" disabled>
                                        Next<span class="fas fa-chevron-right ms-2"></span>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Daily Summary Tab -->
            <div class="tab-pane <?php echo e($activeTab == 'daily' ? 'active' : ''); ?>" id="dailyTab" style="display: none;">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0">Daily Sales Summary</h5>
                        <small class="text-body-tertiary">Sales aggregated by day with performance metrics</small>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <div class="badge bg-info rounded-pill"><?php echo e($dailySales->count()); ?> Days</div>
                        <div class="text-body-tertiary small">
                            Total: Tsh <?php echo e(number_format($dailyTotals['total_amount'], 2)); ?>

                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-body-secondary">
                            <tr>
                                <th class="ps-4 small fw-semibold text-body-tertiary">Date</th>
                                <th class="small fw-semibold text-body-tertiary">Day</th>
                                <th class="small fw-semibold text-body-tertiary">Total Orders</th>
                                <th class="small fw-semibold text-body-tertiary">Subtotal</th>
                                <th class="small fw-semibold text-body-tertiary">Tax</th>
                                <th class="small fw-semibold text-body-tertiary">Total Amount</th>
                                <th class="small fw-semibold text-body-tertiary">Avg Order Value</th>
                                <th class="pe-4 small fw-semibold text-body-tertiary">Day Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $dailySales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-bottom">
                                <td class="ps-4">
                                    <div class="d-flex flex-column">
                                        <span class="fw-semibold"><?php echo e(\Carbon\Carbon::parse($daily->date)->format('M d, Y')); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <span class="fw-semibold"><?php echo e($daily->day_name); ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-primary rounded-pill"><?php echo e($daily->total_orders); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format($daily->total_subtotal, 2)); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format($daily->total_tax, 2)); ?></span>
                                </td>
                                <td>
                                    <span class="fw-bold text-success">Tsh <?php echo e(number_format($daily->total_amount, 2)); ?></span>
                                </td>
                                <td>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format($daily->average_order_value, 2)); ?></span>
                                </td>
                                <td class="pe-4">
                                    <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e(in_array(strtolower($daily->day_name), ['saturday', 'sunday']) ? 'danger' : 'success'); ?>">
                                        <span class="badge-label"><?php echo e(in_array(strtolower($daily->day_name), ['saturday', 'sunday']) ? 'Weekend' : 'Weekday'); ?></span>
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-calendar-day fa-2x mb-2"></i>
                                        <p>No daily sales data found for the selected filters</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <!-- Pagination for Daily Sales -->
                <?php if($dailySales->hasPages()): ?>
                <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
                    <div class="row align-items-center justify-content-between g-3">
                        <div class="col-auto">
                            <p class="mb-0 fs-9 text-body-tertiary">
                                <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                                    Showing <?php echo e(($dailySales->currentPage() - 1) * $dailySales->perPage() + 1); ?> to 
                                    <?php echo e(min($dailySales->currentPage() * $dailySales->perPage(), $dailySales->total())); ?> of 
                                    <?php echo e($dailySales->total()); ?> entries
                                </span>
                            </p>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-2">
                                <?php if($dailySales->onFirstPage()): ?>
                                    <button class="btn btn-sm btn-phoenix-secondary" disabled>
                                        <span class="fas fa-chevron-left me-2"></span>Previous
                                    </button>
                                <?php else: ?>
                                    <a href="<?php echo e($dailySales->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                                        <span class="fas fa-chevron-left me-2"></span>Previous
                                    </a>
                                <?php endif; ?>

                                <?php if($dailySales->hasMorePages()): ?>
                                    <a href="<?php echo e($dailySales->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                                        Next<span class="fas fa-chevron-right ms-2"></span>
                                    </a>
                                <?php else: ?>
                                    <button class="btn btn-sm btn-phoenix-secondary" disabled>
                                        Next<span class="fas fa-chevron-right ms-2"></span>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Add similar pagination structure for other tabs -->
<!-- Add these missing content sections in the blade file -->

<!-- Weekly Summary Tab Content -->
<div class="tab-pane <?php echo e($activeTab == 'weekly' ? 'active' : ''); ?>" id="weeklyTab" style="display: none;">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Weekly Sales Summary</h5>
            <small class="text-body-tertiary">Sales performance by week</small>
        </div>
        <div class="d-flex align-items-center gap-3">
            <div class="badge bg-warning rounded-pill"><?php echo e($weeklySales->count()); ?> Weeks</div>
            <div class="text-body-tertiary small">
                Total: Tsh <?php echo e(number_format($weeklyTotals['total_amount'], 2)); ?>

            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="bg-body-secondary">
                <tr>
                    <th class="ps-4 small fw-semibold text-body-tertiary">Week</th>
                    <th class="small fw-semibold text-body-tertiary">Period</th>
                    <th class="small fw-semibold text-body-tertiary">Total Orders</th>
                    <th class="small fw-semibold text-body-tertiary">Subtotal</th>
                    <th class="small fw-semibold text-body-tertiary">Tax</th>
                    <th class="small fw-semibold text-body-tertiary">Total Amount</th>
                    <th class="pe-4 small fw-semibold text-body-tertiary">Avg Order Value</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $weeklySales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $weekly): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-bottom">
                    <td class="ps-4">
                        <span class="fw-semibold">Week <?php echo e($weekly->week_number); ?>, <?php echo e($weekly->year); ?></span>
                    </td>
                    <td>
                        <small class="text-muted">
                            <?php echo e(\Carbon\Carbon::parse($weekly->week_start)->format('M j')); ?> - 
                            <?php echo e(\Carbon\Carbon::parse($weekly->week_end)->format('M j, Y')); ?>

                        </small>
                    </td>
                    <td>
                        <span class="badge bg-primary rounded-pill"><?php echo e($weekly->total_orders); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($weekly->total_subtotal, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($weekly->total_tax, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-bold text-success">Tsh <?php echo e(number_format($weekly->total_amount, 2)); ?></span>
                    </td>
                    <td class="pe-4">
                        <span class="fw-semibold">Tsh <?php echo e(number_format($weekly->average_order_value, 2)); ?></span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <div class="text-muted">
                            <i class="fas fa-calendar-week fa-2x mb-2"></i>
                            <p>No weekly sales data found for the selected filters</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Pagination for Weekly Sales -->
    <?php if($weeklySales->hasPages()): ?>
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
        <div class="row align-items-center justify-content-between g-3">
            <div class="col-auto">
                <p class="mb-0 fs-9 text-body-tertiary">
                    <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                        Showing <?php echo e(($weeklySales->currentPage() - 1) * $weeklySales->perPage() + 1); ?> to 
                        <?php echo e(min($weeklySales->currentPage() * $weeklySales->perPage(), $weeklySales->total())); ?> of 
                        <?php echo e($weeklySales->total()); ?> entries
                    </span>
                </p>
            </div>
            <div class="col-auto">
                <div class="d-flex gap-2">
                    <?php if($weeklySales->onFirstPage()): ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e($weeklySales->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </a>
                    <?php endif; ?>

                    <?php if($weeklySales->hasMorePages()): ?>
                        <a href="<?php echo e($weeklySales->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Monthly Summary Tab Content -->
<div class="tab-pane <?php echo e($activeTab == 'monthly' ? 'active' : ''); ?>" id="monthlyTab" style="display: none;">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Monthly Sales Summary</h5>
            <small class="text-body-tertiary">Monthly sales performance with growth metrics</small>
        </div>
        <div class="d-flex align-items-center gap-3">
            <div class="badge bg-success rounded-pill"><?php echo e($monthlySales->count()); ?> Months</div>
            <div class="text-body-tertiary small">
                Total: Tsh <?php echo e(number_format($monthlyTotals['total_amount'], 2)); ?>

            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="bg-body-secondary">
                <tr>
                    <th class="ps-4 small fw-semibold text-body-tertiary">Month</th>
                    <th class="small fw-semibold text-body-tertiary">Total Orders</th>
                    <th class="small fw-semibold text-body-tertiary">Subtotal</th>
                    <th class="small fw-semibold text-body-tertiary">Tax</th>
                    <th class="small fw-semibold text-body-tertiary">Total Amount</th>
                    <th class="small fw-semibold text-body-tertiary">Avg Order Value</th>
                    <th class="pe-4 small fw-semibold text-body-tertiary">Growth %</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $monthlySales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthly): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-bottom">
                    <td class="ps-4">
                        <span class="fw-semibold"><?php echo e($monthly->month_name); ?> <?php echo e($monthly->year); ?></span>
                    </td>
                    <td>
                        <span class="badge bg-primary rounded-pill"><?php echo e($monthly->total_orders); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($monthly->total_subtotal, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($monthly->total_tax, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-bold text-success">Tsh <?php echo e(number_format($monthly->total_amount, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($monthly->average_order_value, 2)); ?></span>
                    </td>
                    <td class="pe-4">
                        <?php if($monthly->growth): ?>
                            <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($monthly->growth >= 0 ? 'success' : 'danger'); ?>">
                                <span class="badge-label"><?php echo e(number_format($monthly->growth, 1)); ?>%</span>
                                <span class="ms-1 fas fa-<?php echo e($monthly->growth >= 0 ? 'arrow-up' : 'arrow-down'); ?>"></span>
                            </span>
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <div class="text-muted">
                            <i class="fas fa-calendar-alt fa-2x mb-2"></i>
                            <p>No monthly sales data found for the selected filters</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Pagination for Monthly Sales -->
    <?php if($monthlySales->hasPages()): ?>
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
        <div class="row align-items-center justify-content-between g-3">
            <div class="col-auto">
                <p class="mb-0 fs-9 text-body-tertiary">
                    <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                        Showing <?php echo e(($monthlySales->currentPage() - 1) * $monthlySales->perPage() + 1); ?> to 
                        <?php echo e(min($monthlySales->currentPage() * $monthlySales->perPage(), $monthlySales->total())); ?> of 
                        <?php echo e($monthlySales->total()); ?> entries
                    </span>
                </p>
            </div>
            <div class="col-auto">
                <div class="d-flex gap-2">
                    <?php if($monthlySales->onFirstPage()): ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e($monthlySales->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </a>
                    <?php endif; ?>

                    <?php if($monthlySales->hasMorePages()): ?>
                        <a href="<?php echo e($monthlySales->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Product Performance Tab Content -->
<div class="tab-pane <?php echo e($activeTab == 'products' ? 'active' : ''); ?>" id="productsTab" style="display: none;">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Product Performance Analysis</h5>
            <small class="text-body-tertiary">Top performing products by revenue and quantity</small>
        </div>
        <div class="d-flex align-items-center gap-3">
            <div class="badge bg-info rounded-pill"><?php echo e($productPerformance->count()); ?> Products</div>
            <div class="text-body-tertiary small">
                Total Revenue: Tsh <?php echo e(number_format($productTotals['total_revenue'], 2)); ?>

            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="bg-body-secondary">
                <tr>
                    <th class="ps-4 small fw-semibold text-body-tertiary">Product</th>
                    <th class="small fw-semibold text-body-tertiary">Category</th>
                    <th class="small fw-semibold text-body-tertiary">Quantity Sold</th>
                    <th class="small fw-semibold text-body-tertiary">Times Ordered</th>
                    <th class="small fw-semibold text-body-tertiary">Total Revenue</th>
                    <th class="small fw-semibold text-body-tertiary">Avg Price</th>
                    <th class="pe-4 small fw-semibold text-body-tertiary">Revenue per Item</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $productPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-bottom">
                    <td class="ps-4">
                        <span class="fw-semibold"><?php echo e($product->product_name); ?></span>
                    </td>
                    <td>
                        <span class="text-muted"><?php echo e($product->category_name ?? '—'); ?></span>
                    </td>
                    <td>
                        <span class="badge bg-primary rounded-pill"><?php echo e($product->total_quantity_sold); ?></span>
                    </td>
                    <td>
                        <span class="badge bg-info rounded-pill"><?php echo e($product->times_ordered); ?></span>
                    </td>
                    <td>
                        <span class="fw-bold text-success">Tsh <?php echo e(number_format($product->total_revenue, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($product->average_price, 2)); ?></span>
                    </td>
                    <td class="pe-4">
                        <span class="fw-semibold">Tsh <?php echo e(number_format($product->revenue_per_item, 2)); ?></span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <div class="text-muted">
                            <i class="fas fa-cube fa-2x mb-2"></i>
                            <p>No product performance data found for the selected filters</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Pagination for Product Performance -->
    <?php if($productPerformance->hasPages()): ?>
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
        <div class="row align-items-center justify-content-between g-3">
            <div class="col-auto">
                <p class="mb-0 fs-9 text-body-tertiary">
                    <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                        Showing <?php echo e(($productPerformance->currentPage() - 1) * $productPerformance->perPage() + 1); ?> to 
                        <?php echo e(min($productPerformance->currentPage() * $productPerformance->perPage(), $productPerformance->total())); ?> of 
                        <?php echo e($productPerformance->total()); ?> entries
                    </span>
                </p>
            </div>
            <div class="col-auto">
                <div class="d-flex gap-2">
                    <?php if($productPerformance->onFirstPage()): ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e($productPerformance->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </a>
                    <?php endif; ?>

                    <?php if($productPerformance->hasMorePages()): ?>
                        <a href="<?php echo e($productPerformance->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Waiter Performance Tab Content -->
<div class="tab-pane <?php echo e($activeTab == 'waiters' ? 'active' : ''); ?>" id="waitersTab" style="display: none;">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Waiter Performance Analysis</h5>
            <small class="text-body-tertiary">Waiter performance metrics and rankings</small>
        </div>
        <div class="d-flex align-items-center gap-3">
            <div class="badge bg-warning rounded-pill"><?php echo e($waiterPerformance->count()); ?> Waiters</div>
            <div class="text-body-tertiary small">
                Total Sales: Tsh <?php echo e(number_format($waiterTotals['total_sales'], 2)); ?>

            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="bg-body-secondary">
                <tr>
                    <th class="ps-4 small fw-semibold text-body-tertiary">Waiter</th>
                    <th class="small fw-semibold text-body-tertiary">Total Orders</th>
                    <th class="small fw-semibold text-body-tertiary">Total Sales</th>
                    <th class="small fw-semibold text-body-tertiary">Avg Order Value</th>
                    <th class="small fw-semibold text-body-tertiary">Highest Sale</th>
                    <th class="small fw-semibold text-body-tertiary">Lowest Sale</th>
                    <th class="pe-4 small fw-semibold text-body-tertiary">Performance</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $waiterPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-bottom">
                    <td class="ps-4">
                        <span class="fw-semibold"><?php echo e($waiter->waiter_name); ?></span>
                    </td>
                    <td>
                        <span class="badge bg-primary rounded-pill"><?php echo e($waiter->total_orders); ?></span>
                    </td>
                    <td>
                        <span class="fw-bold text-success">Tsh <?php echo e(number_format($waiter->total_sales, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($waiter->average_order_value, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($waiter->highest_sale, 2)); ?></span>
                    </td>
                    <td>
                        <span class="fw-semibold">Tsh <?php echo e(number_format($waiter->lowest_sale, 2)); ?></span>
                    </td>
                    <td class="pe-4">
                        <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($waiter->performance_class); ?>">
                            <span class="badge-label"><?php echo e($waiter->performance_rating); ?></span>
                        </span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <div class="text-muted">
                            <i class="fas fa-users fa-2x mb-2"></i>
                            <p>No waiter performance data found for the selected filters</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Pagination for Waiter Performance -->
    <?php if($waiterPerformance->hasPages()): ?>
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
        <div class="row align-items-center justify-content-between g-3">
            <div class="col-auto">
                <p class="mb-0 fs-9 text-body-tertiary">
                    <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                        Showing <?php echo e(($waiterPerformance->currentPage() - 1) * $waiterPerformance->perPage() + 1); ?> to 
                        <?php echo e(min($waiterPerformance->currentPage() * $waiterPerformance->perPage(), $waiterPerformance->total())); ?> of 
                        <?php echo e($waiterPerformance->total()); ?> entries
                    </span>
                </p>
            </div>
            <div class="col-auto">
                <div class="d-flex gap-2">
                    <?php if($waiterPerformance->onFirstPage()): ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e($waiterPerformance->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </a>
                    <?php endif; ?>

                    <?php if($waiterPerformance->hasMorePages()): ?>
                        <a href="<?php echo e($waiterPerformance->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Hourly Analysis Tab Content -->
<div class="tab-pane <?php echo e($activeTab == 'hourly' ? 'active' : ''); ?>" id="hourlyTab" style="display: none;">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Hourly Sales Distribution</h5>
            <small class="text-body-tertiary">Sales patterns throughout the day</small>
        </div>
        <div class="d-flex align-items-center gap-3">
            <div class="badge bg-dark rounded-pill"><?php echo e($hourlySales->count()); ?> Hours</div>
            <div class="text-body-tertiary small">
                Total: Tsh <?php echo e(number_format($hourlyTotals['total_amount'], 2)); ?>

            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="bg-body-secondary">
                <tr>
                    <th class="ps-4 small fw-semibold text-body-tertiary">Hour</th>
                    <th class="small fw-semibold text-body-tertiary">Time Period</th>
                    <th class="small fw-semibold text-body-tertiary">Total Orders</th>
                    <th class="small fw-semibold text-body-tertiary">Total Amount</th>
                    <th class="pe-4 small fw-semibold text-body-tertiary">Avg Order Value</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $hourlySales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hourly): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-bottom">
                    <td class="ps-4">
                        <span class="fw-semibold"><?php echo e($hourly->hour_formatted); ?></span>
                    </td>
                    <td>
                        <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($hourly->period_class); ?>">
                            <span class="badge-label"><?php echo e($hourly->time_period); ?></span>
                        </span>
                    </td>
                    <td>
                        <span class="badge bg-primary rounded-pill"><?php echo e($hourly->total_orders); ?></span>
                    </td>
                    <td>
                        <span class="fw-bold text-success">Tsh <?php echo e(number_format($hourly->total_amount, 2)); ?></span>
                    </td>
                    <td class="pe-4">
                        <span class="fw-semibold">Tsh <?php echo e(number_format($hourly->average_order_value, 2)); ?></span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center py-4">
                        <div class="text-muted">
                            <i class="fas fa-clock fa-2x mb-2"></i>
                            <p>No hourly sales data found for the selected filters</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Pagination for Hourly Sales -->
    <?php if($hourlySales->hasPages()): ?>
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis border-top border-translucent py-3">
        <div class="row align-items-center justify-content-between g-3">
            <div class="col-auto">
                <p class="mb-0 fs-9 text-body-tertiary">
                    <span class="d-none d-sm-inline-block" data-list-info="data-list-info">
                        Showing <?php echo e(($hourlySales->currentPage() - 1) * $hourlySales->perPage() + 1); ?> to 
                        <?php echo e(min($hourlySales->currentPage() * $hourlySales->perPage(), $hourlySales->total())); ?> of 
                        <?php echo e($hourlySales->total()); ?> entries
                    </span>
                </p>
            </div>
            <div class="col-auto">
                <div class="d-flex gap-2">
                    <?php if($hourlySales->onFirstPage()): ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e($hourlySales->previousPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            <span class="fas fa-chevron-left me-2"></span>Previous
                        </a>
                    <?php endif; ?>

                    <?php if($hourlySales->hasMorePages()): ?>
                        <a href="<?php echo e($hourlySales->nextPageUrl()); ?>" class="btn btn-sm btn-phoenix-primary">
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-sm btn-phoenix-secondary" disabled>
                            Next<span class="fas fa-chevron-right ms-2"></span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .tab-pane {
        display: none;
    }
    .tab-pane.active {
        display: block;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(0, 0, 0, 0.02);
    }
    .avatar-initial {
        width: 45px;
        height: 45px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Show the active tab on page load
    showTab('<?php echo e($activeTab); ?>');
    
    // Tab click event
    document.querySelectorAll('[data-tab]').forEach(tab => {
        tab.addEventListener('click', function(e) {
            e.preventDefault();
            const tabName = this.getAttribute('data-tab');
            showTab(tabName);
            updateActiveTabInput(tabName);
        });
    });
});

function showTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-pane').forEach(tab => {
        tab.style.display = 'none';
        tab.classList.remove('active');
    });
    
    // Remove active class from all nav links
    document.querySelectorAll('.nav-link').forEach(link => {
        link.classList.remove('active');
    });
    
    // Show selected tab
    const activeTab = document.getElementById(tabName + 'Tab');
    if (activeTab) {
        activeTab.style.display = 'block';
        activeTab.classList.add('active');
    }
    
    // Activate nav link
    const activeNavLink = document.querySelector(`[data-tab="${tabName}"]`);
    if (activeNavLink) {
        activeNavLink.classList.add('active');
    }
}

function updateActiveTabInput(tabName) {
    const activeTabInput = document.getElementById('activeTab');
    if (activeTabInput) {
        activeTabInput.value = tabName;
    }
}

function exportData(type) {
    const form = document.getElementById('filterForm');
    const originalAction = form.action;
    
    // Create a temporary form for export
    const tempForm = document.createElement('form');
    tempForm.method = 'GET';
    tempForm.action = `<?php echo e(url('sales/report/export/${type}')); ?>`;
    tempForm.style.display = 'none';
    
    // Copy all form inputs
    const inputs = form.querySelectorAll('input, select, textarea');
    inputs.forEach(input => {
        const clone = input.cloneNode(true);
        tempForm.appendChild(clone);
    });
    
    document.body.appendChild(tempForm);
    tempForm.submit();
    document.body.removeChild(tempForm);
}

function exportTableData(reportType) {
    const form = document.getElementById('filterForm');
    
    // Create a temporary form for export
    const tempForm = document.createElement('form');
    tempForm.method = 'GET';
    tempForm.action = `<?php echo e(url('sales/report/export/${reportType}')); ?>`;
    tempForm.style.display = 'none';
    
    // Copy all form inputs
    const inputs = form.querySelectorAll('input, select, textarea');
    inputs.forEach(input => {
        const clone = input.cloneNode(true);
        tempForm.appendChild(clone);
    });
    
    document.body.appendChild(tempForm);
    tempForm.submit();
    document.body.removeChild(tempForm);
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/sales/report.blade.php ENDPATH**/ ?>