<?php $__env->startSection('title', 'Validator Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="fw-bold py-3 mb-2">
                <span class="text-muted fw-light">Validator /</span> Dashboard
            </h4>
        </div>
    </div>

    <!-- Quick Stats Row -->
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Total Unattended</h5>
                            <h2 class="mb-0 text-warning" id="total-unattended-count"><?php echo e($sales->count()); ?></h2>
                            <p class="fs-9 mb-0">Receipts pending review</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Today's Receipts</h5>
                            <h2 class="mb-0 text-info" id="today-receipts-count"><?php echo e($todayReceiptsCount ?? 0); ?></h2>
                            <p class="fs-9 mb-0">Created today</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Total Amount</h5>
                            <h2 class="mb-0 text-success" id="total-pending-amount">Tsh. <?php echo e(number_format($totalUnvalidatedAmount ?? 0, 2)); ?></h2>
                            <p class="fs-9 mb-0">Pending verification</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">View Mode</h5>
                            <div class="btn-group w-100" role="group">
                                <input type="radio" class="btn-check" name="view-mode" id="grid-mode" autocomplete="off" checked>
                                <label class="btn btn-outline-primary btn-sm" for="grid-mode">Grid View</label>
                                
                                <input type="radio" class="btn-check" name="view-mode" id="table-mode" autocomplete="off">
                                <label class="btn btn-outline-primary btn-sm" for="table-mode">Table View</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="row g-4">
        <!-- Left Column: Transactions Table (Hidden by default, shows in table mode) -->
        <div class="col-12 col-xl-4 d-none" id="transactionsTableColumn">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Pending Transactions</h5>
                    <small class="text-muted"><?php echo e($sales->count()); ?> records</small>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped mb-0">
                            <thead class="bg-light sticky-top">
                                <tr>
                                    <th class="border-0 ps-3">ID</th>
                                    <th class="border-0">Waiter</th>
                                    <th class="border-0 text-end pe-3">Amount</th>
                                    <th class="border-0 text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody id="transactionsTableBody">
                                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="transaction-row <?php echo e($sale->created_at->gt(now()->subMinute()) ? 'new-receipt' : ''); ?>" 
                                    data-sale-id="<?php echo e($sale->id); ?>"
                                    data-created-at="<?php echo e($sale->created_at->timestamp); ?>">
                                    <td class="fw-bold ps-3">#<?php echo e(str_pad($sale->id, 6, '0', STR_PAD_LEFT)); ?></td>
                                    <td>
                                        <small class="text-muted"><?php echo e($sale->waiter->username ?? 'Unknown'); ?></small>
                                    </td>
                                    <td class="text-end fw-bold text-success pe-3">
                                        Tsh. <?php echo e(number_format($sale->total, 2)); ?>

                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-success mark-attended-btn" 
                                                data-sale-id="<?php echo e($sale->id); ?>"
                                                title="Mark as Attended">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column: Receipts Grid -->
        <div class="col-12 col-xl-8" id="receiptsGridColumn">
            <?php if($sales->count() > 0): ?>
                <!-- Grid Header -->
                <div class="card mb-4">
                    <div class="card-body py-3">
                        <div class="row align-items-center">
                            <div class="col">
                                <h5 class="mb-0">Receipts Preview</h5>
                                <small class="text-muted">Click on receipts to mark as attended</small>
                            </div>
                            <div class="col-auto">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-secondary active" data-grid-size="auto">
                                        <i class="fas fa-desktop"></i> Auto
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" data-grid-size="xl">
                                        <i class="fas fa-th-large"></i> Large
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" data-grid-size="lg">
                                        <i class="fas fa-th"></i> Medium
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" data-grid-size="sm">
                                        <i class="fas fa-th-small"></i> Small
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Receipts Grid -->
                <div class="row g-3" id="receiptsGrid">
                    <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12 col-sm-6 col-lg-4 col-xl-3 receipt-card-container <?php echo e($sale->created_at->gt(now()->subMinute()) ? 'new-receipt' : ''); ?>" 
                         data-sale-id="<?php echo e($sale->id); ?>"
                         data-created-at="<?php echo e($sale->created_at->timestamp); ?>">
                        <div class="card receipt-card h-100">
                            <div class="card-header py-2 bg-warning bg-opacity-10 border-bottom">
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="fw-bold">#<?php echo e(str_pad($sale->id, 6, '0', STR_PAD_LEFT)); ?></small>
                                    <span class="badge bg-warning">Pending</span>
                                </div>
                            </div>
                            <div class="card-body p-3">
                                <!-- Mini Receipt -->
                                <div class="thermal-receipt-mini">
                                    <div class="receipt-header-mini text-center mb-2">
                                        <h6 class="fw-bold mb-1" style="font-size: 0.8rem;">D RESTAURANT</h6>
                                        <p class="mb-1" style="font-size: 0.7rem;"><?php echo e($sale->created_at->format('d M Y H:i')); ?></p>
                                    </div>

                                    <div class="receipt-info-mini mb-2">
                                        <div class="d-flex justify-content-between mb-1">
                                            <small>Waiter:</small>
                                            <small class="fw-bold"><?php echo e($sale->waiter->username ?? 'Unknown'); ?></small>
                                        </div>
                                        <div class="d-flex justify-content-between mb-1">
                                            <small>Payment:</small>
                                            <small><?php echo e($sale->payment_type); ?></small>
                                        </div>
                                    </div>

                                    <div class="receipt-items-mini mb-2">
                                        <?php $__currentLoopData = $sale->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex justify-content-between align-items-start mb-1">
                                            <small class="flex-grow-1 fw-bold" style="font-size: 0.7rem;">
                                                <?php echo e($item->product->product_name); ?>

                                            </small>
                                            <small class="fw-bold" style="font-size: 0.7rem; white-space: nowrap;">
                                                <?php echo e($item->quantity); ?> × <?php echo e(number_format($item->product->selling_price, 0)); ?>

                                            </small>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                    <div class="receipt-totals-mini border-top pt-2">
                                        <div class="d-flex justify-content-between mb-1">
                                            <small>Subtotal:</small>
                                            <small class="fw-bold"><?php echo e(number_format($sale->subtotal, 2)); ?></small>
                                        </div>
                                        <div class="d-flex justify-content-between mb-1">
                                            <small>VAT(18%):</small>
                                            <small class="fw-bold"><?php echo e(number_format($sale->tax, 2)); ?></small>
                                        </div>
                                        <div class="d-flex justify-content-between fw-bold border-top pt-1">
                                            <small>TOTAL:</small>
                                            <small class="text-success"><?php echo e(number_format($sale->total, 2)); ?></small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent border-top pt-3">
                                <div class="d-grid gap-2">
                                    <button class="btn btn-success btn-sm mark-attended-btn" 
                                            data-sale-id="<?php echo e($sale->id); ?>">
                                        <i class="fas fa-check me-1"></i>Mark Attended
                                    </button>
                                    <a href="<?php echo e(url('sales/receipt/'.$sale->id)); ?>" 
                                       class="btn btn-outline-primary btn-sm" 
                                       target="_blank">
                                        <i class="fas fa-eye me-1"></i>View Full
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <!-- Empty State -->
                <div class="card">
                    <div class="card-body text-center py-5">
                        <div class="empty-state-icon mb-3">
                            <i class="fas fa-receipt fa-4x text-muted"></i>
                        </div>
                        <h3 class="text-muted">No Pending Receipts</h3>
                        <p class="text-muted mb-4">All receipts have been reviewed and marked as attended.</p>
                        <button class="btn btn-primary" onclick="location.reload()">
                            <i class="fas fa-refresh me-2"></i>Refresh Page
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Confirmation Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmModalLabel">Confirm Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                <p>Mark this receipt as attended?</p>
                <p class="fw-bold" id="modalReceiptDetails"></p>
            </div>
            <div class="modal-footer justify-content-center">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="confirmMarkAttended">Yes, Mark Attended</button>
            </div>
        </div>
    </div>
</div>

<!-- Toast container -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Thermal receipt mini styling */
.thermal-receipt-mini {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 12px;
    font-family: "Courier New", Courier, monospace;
    color: #2c3e50;
}

.receipt-header-mini h6 {
    color: #2c3e50;
    font-weight: 900;
}

.receipt-card {
    transition: all 0.3s ease;
    border: 2px solid transparent;
    background: #ffffff;
    color: #2c3e50;
}

.receipt-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    border-color: #ffc107;
}

.receipt-card.attending {
    border-color: #28a745;
    background: linear-gradient(135deg, #ffffff 0%, #f8fff9 100%);
}

/* New receipt highlighting */
.new-receipt .receipt-card {
    animation: newReceiptGlow 2s ease-in-out infinite;
    border-color: #dc3545;
    box-shadow: 0 0 15px rgba(220, 53, 69, 0.5);
}

.new-receipt .transaction-row {
    animation: newReceiptRowGlow 2s ease-in-out infinite;
    background-color: rgba(220, 53, 69, 0.05) !important;
}

@keyframes newReceiptGlow {
    0%, 100% {
        box-shadow: 0 0 15px rgba(220, 53, 69, 0.5);
        border-color: #dc3545;
    }
    50% {
        box-shadow: 0 0 25px rgba(220, 53, 69, 0.8);
        border-color: #ff6b7a;
    }
}

@keyframes newReceiptRowGlow {
    0%, 100% {
        background-color: rgba(220, 53, 69, 0.05) !important;
    }
    50% {
        background-color: rgba(220, 53, 69, 0.1) !important;
    }
}

/* Receipt items - no scroll, full display */
.receipt-items-mini {
    max-height: none !important;
    overflow-y: visible !important;
}

.receipt-items-mini .fw-bold {
    font-weight: 600 !important;
}

/* Table responsive - no scroll with better spacing */
.table-responsive {
    overflow-x: auto;
    max-height: none !important;
    overflow-y: visible !important;
}

/* Table cell spacing */
.table th,
.table td {
    padding: 0.75rem 0.5rem;
}

.table th:first-child,
.table td:first-child {
    padding-left: 1rem !important;
}

.table th:last-child,
.table td:last-child {
    padding-right: 1rem !important;
}

/* Button styling - Light mode only */
.btn-outline-secondary {
    color: #6c757d;
    border-color: #6c757d;
    background: transparent;
}

.btn-outline-secondary:hover,
.btn-outline-secondary:focus,
.btn-outline-secondary:active,
.btn-outline-secondary.active {
    color: #ffffff;
    background-color: #6c757d;
    border-color: #6c757d;
}

.btn-outline-primary {
    color: #007bff;
    border-color: #007bff;
    background: transparent;
}

.btn-outline-primary:hover,
.btn-outline-primary:focus,
.btn-outline-primary:active,
.btn-outline-primary.active {
    color: #ffffff;
    background-color: #007bff;
    border-color: #007bff;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
    color: #ffffff;
}

.btn-success:hover {
    background-color: #218838;
    border-color: #1e7e34;
}

.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
    color: #ffffff;
}

.btn-primary:hover {
    background-color: #0056b3;
    border-color: #004085;
}

/* Enhanced responsive adjustments */
@media (max-width: 1400px) {
    .receipt-card-container {
        flex: 0 0 25%;
        max-width: 25%;
    }
}

@media (max-width: 1200px) {
    .receipt-card-container {
        flex: 0 0 33.333%;
        max-width: 33.333%;
    }
    
    /* Responsive table column sizing */
    #transactionsTableColumn {
        flex: 0 0 35%;
        max-width: 35%;
    }
    
    #receiptsGridColumn {
        flex: 0 0 65%;
        max-width: 65%;
    }
}

@media (max-width: 992px) {
    .receipt-card-container {
        flex: 0 0 50%;
        max-width: 50%;
    }
    
    /* Stack table and grid on medium screens */
    #transactionsTableColumn {
        flex: 0 0 100% !important;
        max-width: 100% !important;
        margin-bottom: 1rem;
    }
    
    #receiptsGridColumn {
        flex: 0 0 100% !important;
        max-width: 100% !important;
    }
}

@media (max-width: 768px) {
    .receipt-card-container {
        flex: 0 0 100% !important;
        max-width: 100% !important;
    }
    
    .btn-group-sm .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }
    
    /* Better table spacing on mobile */
    .table th,
    .table td {
        padding: 0.5rem 0.25rem;
    }
    
    .table th:first-child,
    .table td:first-child {
        padding-left: 0.75rem !important;
    }
    
    .table th:last-child,
    .table td:last-child {
        padding-right: 0.75rem !important;
    }
}

@media (max-width: 576px) {
    .card-body {
        padding: 0.75rem;
    }
    
    .thermal-receipt-mini {
        padding: 8px;
    }
    
    .btn-group {
        flex-wrap: wrap;
    }
    
    .btn-group .btn {
        flex: 1;
        min-width: 60px;
    }
    
    /* Even more compact table on small screens */
    .table th,
    .table td {
        padding: 0.4rem 0.2rem;
        font-size: 0.875rem;
    }
    
    .table th:first-child,
    .table td:first-child {
        padding-left: 0.5rem !important;
    }
    
    .table th:last-child,
    .table td:last-child {
        padding-right: 0.5rem !important;
    }
}

/* Animation for disappearing receipts */
.receipt-fade-out {
    animation: fadeOutScale 0.5s ease forwards;
}

@keyframes fadeOutScale {
    to {
        opacity: 0;
        transform: scale(0.8);
    }
}

/* Loading indicator */
.loading-indicator {
    display: none;
    text-align: center;
    padding: 10px;
    color: #6c757d;
}

.loading-indicator.show {
    display: block;
}

/* Ensure proper spacing in full screen mode */
.full-screen-grid .receipt-card-container {
    flex: 0 0 25%;
    max-width: 25%;
}

/* Grid size classes */
.receipts-grid-auto .receipt-card-container {
    flex: 0 0 25%;
    max-width: 25%;
}

.receipts-grid-xl .receipt-card-container {
    flex: 0 0 20%;
    max-width: 20%;
}

.receipts-grid-lg .receipt-card-container {
    flex: 0 0 25%;
    max-width: 25%;
}

.receipts-grid-sm .receipt-card-container {
    flex: 0 0 33.333%;
    max-width: 33.333%;
}

@media (max-width: 1400px) {
    .receipts-grid-auto .receipt-card-container,
    .receipts-grid-xl .receipt-card-container {
        flex: 0 0 25%;
        max-width: 25%;
    }
    
    .receipts-grid-sm .receipt-card-container {
        flex: 0 0 50%;
        max-width: 50%;
    }
}

@media (max-width: 1200px) {
    .receipts-grid-auto .receipt-card-container,
    .receipts-grid-xl .receipt-card-container,
    .receipts-grid-lg .receipt-card-container {
        flex: 0 0 33.333%;
        max-width: 33.333%;
    }
    
    .receipts-grid-sm .receipt-card-container {
        flex: 0 0 50%;
        max-width: 50%;
    }
}

@media (max-width: 992px) {
    .receipts-grid-auto .receipt-card-container,
    .receipts-grid-xl .receipt-card-container,
    .receipts-grid-lg .receipt-card-container,
    .receipts-grid-sm .receipt-card-container {
        flex: 0 0 50%;
        max-width: 50%;
    }
}

@media (max-width: 768px) {
    .receipts-grid-auto .receipt-card-container,
    .receipts-grid-xl .receipt-card-container,
    .receipts-grid-lg .receipt-card-container,
    .receipts-grid-sm .receipt-card-container {
        flex: 0 0 100%;
        max-width: 100%;
    }
}

/* Table row hover effect */
.table-hover tbody tr:hover {
    background-color: rgba(0, 0, 0, 0.075);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let currentSaleId = null;
    let currentReceiptElement = null;
    let lastUpdateTime = Date.now();
    let knownReceipts = new Set();
    
    // Initialize known receipts
    document.querySelectorAll('.receipt-card-container, .transaction-row').forEach(element => {
        const saleId = element.getAttribute('data-sale-id');
        if (saleId) {
            knownReceipts.add(saleId);
        }
    });
    
    // View Mode Toggle
    const viewModeRadios = document.querySelectorAll('input[name="view-mode"]');
    const transactionsTableColumn = document.getElementById('transactionsTableColumn');
    const receiptsGridColumn = document.getElementById('receiptsGridColumn');
    const receiptsGrid = document.getElementById('receiptsGrid');
    
    function updateLayout() {
        const isTableMode = document.getElementById('table-mode').checked;
        
        if (isTableMode) {
            transactionsTableColumn.classList.remove('d-none');
            receiptsGridColumn.classList.remove('col-xl-12');
            receiptsGridColumn.classList.add('col-xl-8');
            receiptsGrid.classList.remove('full-screen-grid');
        } else {
            transactionsTableColumn.classList.add('d-none');
            receiptsGridColumn.classList.remove('col-xl-8');
            receiptsGridColumn.classList.add('col-xl-12');
            receiptsGrid.classList.add('full-screen-grid');
        }
        
        // Update responsive behavior
        updateResponsiveLayout();
    }
    
    function updateResponsiveLayout() {
        const screenWidth = window.innerWidth;
        const isTableMode = document.getElementById('table-mode').checked;
        
        if (isTableMode) {
            if (screenWidth <= 992) {
                // Stack layout on medium and small screens
                transactionsTableColumn.classList.remove('col-xl-4');
                receiptsGridColumn.classList.remove('col-xl-8');
            } else {
                // Side by side on large screens
                transactionsTableColumn.classList.add('col-xl-4');
                receiptsGridColumn.classList.add('col-xl-8');
            }
        }
    }
    
    viewModeRadios.forEach(radio => {
        radio.addEventListener('change', updateLayout);
    });
    
    // Grid Size Controls
    const gridSizeButtons = document.querySelectorAll('[data-grid-size]');
    
    gridSizeButtons.forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            gridSizeButtons.forEach(btn => btn.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            // Remove existing grid size classes
            receiptsGrid.classList.remove(
                'receipts-grid-auto', 
                'receipts-grid-xl', 
                'receipts-grid-lg', 
                'receipts-grid-sm'
            );
            
            // Add new grid size class
            const size = this.getAttribute('data-grid-size');
            receiptsGrid.classList.add(`receipts-grid-${size}`);
        });
    });
    
    // Initialize with auto-responsive grid
    document.querySelector('[data-grid-size="auto"]').click();
    
    // Handle window resize for responsive layout
    window.addEventListener('resize', updateResponsiveLayout);
    
    // Mark as Attended functionality
    document.addEventListener('click', function(e) {
        const markBtn = e.target.closest('.mark-attended-btn');
        if (!markBtn) return;
        
        e.preventDefault();
        e.stopPropagation();
        
        currentSaleId = markBtn.getAttribute('data-sale-id');
        currentReceiptElement = markBtn.closest('.receipt-card-container') || 
                               markBtn.closest('.transaction-row');
        
        // Get receipt details for modal
        const receiptId = currentSaleId.padStart(6, '0');
        const amountElement = currentReceiptElement.querySelector('.text-success');
        const amount = amountElement ? amountElement.textContent.trim() : 'N/A';
        
        document.getElementById('modalReceiptDetails').textContent = 
            `Receipt #${receiptId} - ${amount}`;
        
        // Show confirmation modal
        const confirmModal = new bootstrap.Modal(document.getElementById('confirmModal'));
        confirmModal.show();
    });
    
    // Confirm mark as attended
    document.getElementById('confirmMarkAttended').addEventListener('click', function() {
        if (!currentSaleId) return;
        
        // Close modal
        const confirmModal = bootstrap.Modal.getInstance(document.getElementById('confirmModal'));
        confirmModal.hide();
        
        // Send AJAX request
        markReceiptAsAttended(currentSaleId, currentReceiptElement);
    });
    
    // Function to mark receipt as attended
    function markReceiptAsAttended(saleId, receiptElement) {
        // Show loading state
        if (receiptElement) {
            receiptElement.style.opacity = '0.6';
            receiptElement.style.pointerEvents = 'none';
        }
        
        fetch(`/validator/mark-attended/${saleId}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showToast(data.message || 'Receipt marked as attended successfully!', 'success');
                
                // Remove from known receipts
                knownReceipts.delete(saleId.toString());
                
                // Remove receipt element with animation
                if (receiptElement) {
                    receiptElement.classList.add('receipt-fade-out');
                    setTimeout(() => {
                        receiptElement.remove();
                        updateDashboardStats();
                        checkEmptyState();
                        updateLayout(); // Update layout after removal
                    }, 500);
                }
            } else {
                showToast(data.error || 'Failed to mark receipt', 'danger');
                resetReceiptElement(receiptElement);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Error: Failed to mark receipt as attended', 'danger');
            resetReceiptElement(receiptElement);
        });
    }
    
    function resetReceiptElement(element) {
        if (element) {
            element.style.opacity = '';
            element.style.pointerEvents = '';
        }
    }
    
    function updateDashboardStats() {
        // Update unattended count
        const unattendedCountElement = document.getElementById('total-unattended-count');
        if (unattendedCountElement) {
            let currentCount = parseInt(unattendedCountElement.textContent) || 0;
            if (currentCount > 0) {
                unattendedCountElement.textContent = currentCount - 1;
            }
        }
        
        // Update total amount (simplified - in real app you'd fetch this from server)
        const totalAmountElement = document.getElementById('total-pending-amount');
        if (totalAmountElement) {
            // This is a simplified update - in production you'd want to fetch actual data
            const currentAmountText = totalAmountElement.textContent;
            const currentAmount = parseFloat(currentAmountText.replace(/[^\d.]/g, '')) || 0;
            
            // Find the amount of the removed receipt
            if (currentReceiptElement) {
                const amountElement = currentReceiptElement.querySelector('.text-success');
                if (amountElement) {
                    const removedAmount = parseFloat(amountElement.textContent.replace(/[^\d.]/g, '')) || 0;
                    const newAmount = Math.max(0, currentAmount - removedAmount);
                    totalAmountElement.textContent = `Tsh. ${newAmount.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
                }
            }
        }
    }
    
    function checkEmptyState() {
        const receiptCards = document.querySelectorAll('.receipt-card-container');
        const transactionRows = document.querySelectorAll('.transaction-row');
        
        if (receiptCards.length === 0 && transactionRows.length === 0) {
            // Reload page to show empty state
            setTimeout(() => location.reload(), 1000);
        }
    }
    
    // Live update functionality
    function checkForNewReceipts() {
        fetch('/validator/dashboard-data', {
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            // Update counts
            if (data.unattendedCount !== undefined) {
                document.getElementById('total-unattended-count').textContent = data.unattendedCount;
            }
            
            if (data.todayReceiptsCount !== undefined) {
                document.getElementById('today-receipts-count').textContent = data.todayReceiptsCount;
            }
            
            if (data.totalUnvalidatedAmount !== undefined) {
                document.getElementById('total-pending-amount').textContent = 
                    `Tsh. ${parseFloat(data.totalUnvalidatedAmount).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
            }
            
            // Check for new receipts
            if (data.sales && Array.isArray(data.sales)) {
                data.sales.forEach(sale => {
                    if (!knownReceipts.has(sale.id.toString())) {
                        // New receipt found
                        knownReceipts.add(sale.id.toString());
                        addNewReceipt(sale);
                    }
                });
            }
            
            // Update last update time
            lastUpdateTime = Date.now();
        })
        .catch(error => {
            console.error('Error fetching dashboard data:', error);
        });
    }
    
    function addNewReceipt(sale) {
        // Create new receipt card
        const receiptCardHtml = createReceiptCardHtml(sale);
        
        // Add to grid
        const receiptsGrid = document.getElementById('receiptsGrid');
        if (receiptsGrid) {
            receiptsGrid.insertAdjacentHTML('afterbegin', receiptCardHtml);
            
            // Add to table if in table mode
            const transactionsTableBody = document.getElementById('transactionsTableBody');
            if (transactionsTableBody && document.getElementById('table-mode').checked) {
                const tableRowHtml = createTableRowHtml(sale);
                transactionsTableBody.insertAdjacentHTML('afterbegin', tableRowHtml);
            }
            
            // Show notification
            showToast(`New receipt #${String(sale.id).padStart(6, '0')} added!`, 'info');
            
            // Update layout
            updateLayout();
        }
    }
    
    function createReceiptCardHtml(sale) {
        const receiptId = String(sale.id).padStart(6, '0');
        const createdTime = new Date(sale.created_at).toLocaleString('en-US', {
            day: 'numeric',
            month: 'short',
            year: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        });
        
        // Format items for display - show ALL items without scroll
        let itemsHtml = '';
        sale.items.forEach(item => {
            itemsHtml += `
                <div class="d-flex justify-content-between align-items-start mb-1">
                    <small class="flex-grow-1 fw-bold" style="font-size: 0.7rem;">
                        ${item.product.product_name}
                    </small>
                    <small class="fw-bold" style="font-size: 0.7rem; white-space: nowrap;">
                        ${item.quantity} × ${parseFloat(item.product.selling_price).toLocaleString('en-US', {minimumFractionDigits: 0, maximumFractionDigits: 0})}
                    </small>
                </div>
            `;
        });
        
        return `
            <div class="col-12 col-sm-6 col-lg-4 col-xl-3 receipt-card-container new-receipt" 
                 data-sale-id="${sale.id}"
                 data-created-at="${new Date(sale.created_at).getTime()}">
                <div class="card receipt-card h-100">
                    <div class="card-header py-2 bg-warning bg-opacity-10 border-bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="fw-bold">#${receiptId}</small>
                            <span class="badge bg-warning">Pending</span>
                        </div>
                    </div>
                    <div class="card-body p-3">
                        <div class="thermal-receipt-mini">
                            <div class="receipt-header-mini text-center mb-2">
                                <h6 class="fw-bold mb-1" style="font-size: 0.8rem;">D RESTAURANT</h6>
                                <p class="mb-1" style="font-size: 0.7rem;">${createdTime}</p>
                            </div>
                            <div class="receipt-info-mini mb-2">
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Waiter:</small>
                                    <small class="fw-bold">${sale.waiter?.username || 'Unknown'}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Payment:</small>
                                    <small>${sale.payment_type}</small>
                                </div>
                            </div>
                            <div class="receipt-items-mini mb-2">
                                ${itemsHtml}
                            </div>
                            <div class="receipt-totals-mini border-top pt-2">
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Subtotal:</small>
                                    <small class="fw-bold">${parseFloat(sale.subtotal).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>VAT(18%):</small>
                                    <small class="fw-bold">${parseFloat(sale.tax).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</small>
                                </div>
                                <div class="d-flex justify-content-between fw-bold border-top pt-1">
                                    <small>TOTAL:</small>
                                    <small class="text-success">${parseFloat(sale.total).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-transparent border-top pt-3">
                        <div class="d-grid gap-2">
                            <button class="btn btn-success btn-sm mark-attended-btn" 
                                    data-sale-id="${sale.id}">
                                <i class="fas fa-check me-1"></i>Mark Attended
                            </button>
                            <a href="/sales/receipt/${sale.id}" 
                               class="btn btn-outline-primary btn-sm" 
                               target="_blank">
                                <i class="fas fa-eye me-1"></i>View Full
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        `;
    }
    
    function createTableRowHtml(sale) {
        const receiptId = String(sale.id).padStart(6, '0');
        return `
            <tr class="transaction-row new-receipt" 
                data-sale-id="${sale.id}"
                data-created-at="${new Date(sale.created_at).getTime()}">
                <td class="fw-bold ps-3">#${receiptId}</td>
                <td>
                    <small class="text-muted">${sale.waiter?.username || 'Unknown'}</small>
                </td>
                <td class="text-end fw-bold text-success pe-3">
                    Tsh. ${parseFloat(sale.total).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}
                </td>
                <td class="text-center">
                    <button class="btn btn-sm btn-success mark-attended-btn" 
                            data-sale-id="${sale.id}"
                            title="Mark as Attended">
                        <i class="fas fa-check"></i>
                    </button>
                </td>
            </tr>
        `;
    }
    
    // Remove new receipt highlighting after 1 minute
    function checkNewReceiptHighlighting() {
        const now = Date.now();
        const oneMinuteAgo = now - (60 * 1000);
        
        document.querySelectorAll('.new-receipt').forEach(element => {
            const createdAt = parseInt(element.getAttribute('data-created-at'));
            if (createdAt < oneMinuteAgo) {
                element.classList.remove('new-receipt');
            }
        });
    }
    
    // Toast helper function
    function showToast(message, type = 'success') {
        const existingToasts = document.querySelectorAll('.toast');
        existingToasts.forEach(toast => toast.remove());
        
        const toastHTML = `
            <div class="toast align-items-center text-bg-${type} border-0 show" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        const toastContainer = document.querySelector('.toast-container');
        if (toastContainer) {
            toastContainer.innerHTML = toastHTML;
            const toastElement = toastContainer.querySelector('.toast');
            const toast = new bootstrap.Toast(toastElement, { delay: 3000 });
            toast.show();
        }
    }
    
    // Set up periodic updates
    setInterval(checkForNewReceipts, 10000); // Check every 10 seconds
    setInterval(checkNewReceiptHighlighting, 5000); // Check highlighting every 5 seconds
    
    // Initial setup
    checkForNewReceipts();
    updateLayout();
    updateResponsiveLayout();
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/dashboard/validator_list.blade.php ENDPATH**/ ?>