<?php $__env->startSection('title', 'Sales'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
        <div class="mb-3 mb-md-0">
            <h4 class="fw-bold mb-2">
                <span class="text-muted fw-light">Sales /</span> Point of Sale
            </h4>
            <p class="text-body-tertiary mb-0">Manage products and process orders</p>
        </div>
        <?php if(auth()->user()->is_role == 3): ?>
            <div class="badge badge-phoenix badge-phoenix-success rounded-3 fs-4 px-3 py-2 shadow-sm ms-n2" 
                style="text-transform: none;">
                <i class="fas fa-user me-2"></i>
                <?php echo e(ucwords(strtolower(auth()->user()->name))); ?>

            </div>
        <?php endif; ?>
        <div class="d-flex flex-wrap gap-2">
            <div class="badge bg-primary rounded-pill fs-9 px-3 py-2">
                <i class="fas fa-shopping-cart me-2"></i>
                <span id="cartCount"><?php echo e(count(session('cart', []))); ?></span> items
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Products Section -->
        <div class="col-12 col-xl-8 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
                    <h5 class="mb-0">Products</h5>
                    <div class="w-100 w-md-auto">
                        <form id="searchForm" class="w-100">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text bg-body-secondary border-end-0">
                                    <i class="fas fa-search text-muted"></i>
                                </span>
                                <input type="text" name="q" class="form-control border-start-0" 
                                       placeholder="Search products..." value="<?php echo e(request('q')); ?>"
                                       style="border-radius: 0 0.375rem 0.375rem 0;">
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card-body p-0">
                    <!-- Category Tabs - Horizontal scroll on mobile -->
                    <div class="border-bottom">
                        <div class="nav-scrollable" style="overflow-x: auto; white-space: nowrap;">
                            <ul class="nav nav-tabs border-0 px-3" id="categoryTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active py-3 px-3" id="all-tab" data-bs-toggle="tab" 
                                            data-bs-target="#all" type="button" role="tab" aria-controls="all" aria-selected="true">
                                        All
                                    </button>
                                </li>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link py-3 px-3" id="category-<?php echo e($category->id); ?>-tab" 
                                            data-bs-toggle="tab" data-bs-target="#category-<?php echo e($category->id); ?>" 
                                            type="button" role="tab" aria-controls="category-<?php echo e($category->id); ?>" 
                                            aria-selected="false">
                                        <?php echo e(ucwords($category->category_name)); ?>

                                    </button>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <!-- Products Grid -->
                    <div class="tab-content p-3" id="categoryTabContent">
                        <!-- All Products -->
                        <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                            <div id="productsGrid" class="alphabet-grid">
                                <?php
                                    // Group products by first letter
                                    $groupedProducts = [];
                                    foreach($products as $product) {
                                        $firstLetter = strtoupper(substr($product->product_name, 0, 1));
                                        if (!isset($groupedProducts[$firstLetter])) {
                                            $groupedProducts[$firstLetter] = [];
                                        }
                                        $groupedProducts[$firstLetter][] = $product;
                                    }
                                    
                                    // Sort the groups alphabetically
                                    ksort($groupedProducts);
                                ?>
                                
                                <?php $__empty_1 = true; $__currentLoopData = $groupedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter => $letterProducts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="alphabet-section d-inline-block me-4 mb-3">
                                    <div class="alphabet-header mb-2">
                                        <span class="fw-bold text-primary bg-light rounded px-2 py-1"><?php echo e($letter); ?></span>
                                    </div>
                                    <div class="products-row d-flex flex-wrap gap-2">
                                        <?php $__currentLoopData = $letterProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="product-item">
                                            <div class="card product-card cursor-pointer border-0 shadow-sm" 
                                                 data-product-id="<?php echo e($product->id); ?>" style="width: 120px;">
                                                <div class="card-body text-center p-2 d-flex flex-column justify-content-between">
                                                    <div class="mb-1">
                                                        <h6 class="card-title mb-1 text-truncate fw-semibold" style="font-size: 0.8rem;">
                                                            <?php echo e(ucwords($product->product_name)); ?>

                                                        </h6>
                                                    </div>
                                                    <div>
                                                        <p class="card-text mb-0 text-success fw-bold" style="font-size: 0.75rem;">
                                                            Tsh <?php echo e(number_format($product->selling_price, 0)); ?>

                                                        </p>
                                                        <small class="text-muted d-block mt-1" style="font-size: 0.7rem;">Tap to add</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-12 text-center py-5">
                                    <i class="fas fa-search text-muted fa-2x mb-3"></i>
                                    <p class="text-muted mb-0">No products found</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Category Products -->
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane fade" id="category-<?php echo e($category->id); ?>" role="tabpanel" 
                             aria-labelledby="category-<?php echo e($category->id); ?>-tab">
                            <div id="categoryProducts-<?php echo e($category->id); ?>" class="alphabet-grid">
                                <?php
                                    // Group category products by first letter
                                    $categoryGroupedProducts = [];
                                    foreach($category->products as $product) {
                                        $firstLetter = strtoupper(substr($product->product_name, 0, 1));
                                        if (!isset($categoryGroupedProducts[$firstLetter])) {
                                            $categoryGroupedProducts[$firstLetter] = [];
                                        }
                                        $categoryGroupedProducts[$firstLetter][] = $product;
                                    }
                                    
                                    // Sort the groups alphabetically
                                    ksort($categoryGroupedProducts);
                                ?>
                                
                                <?php $__empty_1 = true; $__currentLoopData = $categoryGroupedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter => $letterProducts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="alphabet-section d-inline-block me-4 mb-3">
                                    <div class="alphabet-header mb-2">
                                        <span class="fw-bold text-primary bg-light rounded px-2 py-1"><?php echo e($letter); ?></span>
                                    </div>
                                    <div class="products-row d-flex flex-wrap gap-2">
                                        <?php $__currentLoopData = $letterProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="product-item">
                                            <div class="card product-card cursor-pointer border-0 shadow-sm" 
                                                 data-product-id="<?php echo e($product->id); ?>" style="width: 120px;">
                                                <div class="card-body text-center p-2 d-flex flex-column justify-content-between">
                                                    <div class="mb-1">
                                                        <h6 class="card-title mb-1 text-truncate fw-semibold" style="font-size: 0.8rem;">
                                                            <?php echo e(ucwords($product->product_name)); ?>

                                                        </h6>
                                                    </div>
                                                    <div>
                                                        <p class="card-text mb-0 text-success fw-bold" style="font-size: 0.75rem;">
                                                            Tsh <?php echo e(number_format($product->selling_price, 0)); ?>

                                                        </p>
                                                        <small class="text-muted d-block mt-1" style="font-size: 0.7rem;">Tap to add</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-12 text-center py-5">
                                    <i class="fas fa-folder-open text-muted fa-2x mb-3"></i>
                                    <p class="text-muted mb-0">No products in this category</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cart Section -->
        <div class="col-12 col-xl-4">
            <div class="card sticky-top" style="top: 1rem;">
                <div class="card-header d-flex justify-content-between align-items-center py-3">
                    <h5 class="mb-0">Order Summary</h5>
                    <span class="badge bg-primary rounded-pill fs-8" id="cartCountBadge">
                        <?php echo e(count(session('cart', []))); ?>

                    </span>
                </div>
                <div class="card-body">
                    <!-- Waiter Selection -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Waiter</label>
                        <?php if(auth()->user()->is_role == 3): ?>
                            <!-- For waiters - show readonly field with their name -->
                            <div class="form-control form-control-sm bg-light">
                                <i class="fas fa-user me-2 text-primary"></i>
                                <?php echo e(auth()->user()->name); ?> (You)
                            </div>
                            <input type="hidden" id="waiterSelect" name="waiter_id" value="<?php echo e(auth()->user()->id); ?>">
                        <?php else: ?>
                            <!-- For admin/cashier - show dropdown -->
                            <select class="form-select form-select-sm" id="waiterSelect" name="waiter_id" required>
                                <option value="" selected disabled>-- Select Waiter --</option>
                                <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($waiter->id); ?>"><?php echo e(ucwords($waiter->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>

                    <!-- Cart Items -->
                    <div class="mb-4">
                        <div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
                            <table class="table table-borderless table-sm" id="cartTable">
                                <thead class="bg-body-secondary sticky-top">
                                    <tr>
                                        <th class="small fw-semibold">Product</th>
                                        <th class="text-center small fw-semibold">Qty</th>
                                        <th class="text-end small fw-semibold">Price</th>
                                        <th class="text-end small fw-semibold"></th>
                                    </tr>
                                </thead>
                                <tbody id="cartItems">
                                    <?php $cart = session('cart', []); ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr data-product-id="<?php echo e($id); ?>" class="border-bottom">
                                        <td class="py-2">
                                            <div class="d-flex align-items-center">
                                                <div class="ms-2">
                                                    <h6 class="mb-0 small fw-semibold"><?php echo e(ucwords($item['name'])); ?></h6>
                                                    <small class="text-muted">Tsh <?php echo e(number_format((float)$item['selling_price'], 0)); ?> each</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center py-2">
                                            <div class="quantity-controls d-flex align-items-center justify-content-center">
                                                <button class="btn btn-sm btn-outline-secondary decrease-qty p-1" 
                                                        style="width: 28px; height: 28px;" type="button">-</button>
                                                <span class="mx-2 quantity-display small fw-semibold"><?php echo e(number_format((float) $item['quantity'], 2, '.', ',')); ?></span>
                                                <button class="btn btn-sm btn-outline-secondary increase-qty p-1" 
                                                        style="width: 28px; height: 28px;" type="button">+</button>
                                            </div>
                                        </td>
                                        <td class="text-end fw-bold py-2 small">
                                            Tsh <?php echo e(number_format((float)$item['selling_price'] * $item['quantity'], 0)); ?>

                                        </td>
                                        <td class="text-end py-2">
                                            <button class="btn btn-sm btn-outline-danger remove-item p-1" 
                                                    style="width: 28px; height: 28px;" type="button">
                                                <i class="fas fa-trash fa-xs"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr id="emptyCart">
                                        <td colspan="4" class="text-center text-muted py-4">
                                            <i class="fas fa-shopping-cart fa-2x mb-2 d-block"></i>
                                            Your cart is empty
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Cart Summary -->
                    <div class="border-top pt-3">
                        <div class="d-flex justify-content-between mb-2 small">
                            <span class="text-muted">Subtotal:</span>
                            <span id="subtotal">Tsh <?php echo e(number_format((float)collect($cart)->sum(function($item) { return $item['selling_price'] * $item['quantity'] * 0.82; }), 0)); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-3 small">
                            <span class="text-muted">VAT (18%):</span>
                            <span id="taxAmount">Tsh <?php echo e(number_format((float)collect($cart)->sum(function($item) { return $item['selling_price'] * $item['quantity'] * 0.18; }), 0)); ?></span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3 fw-bold fs-6 border-top pt-2">
                            <span>Total: </span>
                            <span id="totalAmount">Tsh <?php echo e(number_format((float)collect($cart)->sum(function($item) { return $item['selling_price'] * $item['quantity']; }), 0)); ?></span>
                        </div>

                        <!-- Payment Options -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold small">Payment Method</label>
                            <select class="form-select form-select-sm" id="paymentMethod" name="payment_type">
                                <option value="Cash">Cash</option>
                                <option value="Mobile">Mobile</option>
                            </select>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-grid gap-2">
                            <button class="btn btn-outline-danger btn-sm" id="clearCartBtn" 
                                    <?php echo e(count($cart) == 0 ? 'disabled' : ''); ?>>
                                <i class="fas fa-trash me-2"></i>Clear Cart
                            </button>
                            <div class="btn-group" role="group">
                                <button class="btn btn-warning btn-sm" id="billBtn" 
                                        <?php echo e(count($cart) == 0 ? 'disabled' : ''); ?>>
                                    <i class="fas fa-receipt me-2"></i>Bill
                                </button>
                                <button class="btn btn-primary btn-sm" id="payBtn" 
                                        <?php echo e(count($cart) == 0 ? 'disabled' : ''); ?>>
                                    <i class="fas fa-credit-card me-2"></i>Pay
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Receipt Modal -->
<div class="modal fade" id="receiptModal" tabindex="-1" aria-labelledby="receiptModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0 pb-0">
                <h5 class="modal-title w-100 text-center">RECEIPT PREVIEW</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-3">
                <div id="receiptContent" class="receipt-wrapper">
                    <!-- Receipt content injected here -->
                </div>
            </div>
<div class="modal-footer border-0 justify-content-center pt-0">
    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal" id="cancelReceiptBtn">
        Cancel
    </button>
    <button type="button" class="btn btn-success btn-sm" id="confirmPrintReceiptBtn">
        <?php echo e(strtoupper(auth()->user()->username)); ?> Print
    </button>
</div>

        </div>
    </div>
</div>

<!-- Clear Cart Confirmation Modal -->
<div class="modal fade" id="clearCartModal" tabindex="-1" aria-labelledby="clearCartModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-danger text-white border-0">
                <h6 class="modal-title" id="clearCartModalLabel">Clear Cart?</h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center py-3">
                <i class="fas fa-exclamation-triangle text-warning fa-2x mb-3"></i>
                <p class="small text-muted mb-0">Remove all items from cart?</p>
            </div>
            <div class="modal-footer border-0 justify-content-center">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                <button type="button" id="confirmClearCart" class="btn btn-danger btn-sm">Clear</button>
            </div>
        </div>
    </div>
</div>

<!-- Toast container -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 2000"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    // CSRF Token for final submission only
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    
    // DOM Elements
    const productsGrid = document.getElementById('productsGrid');
    const cartItems = document.getElementById('cartItems');
    const cartCount = document.getElementById('cartCount');
    const cartCountBadge = document.getElementById('cartCountBadge');
    const subtotalEl = document.getElementById('subtotal');
    const taxAmountEl = document.getElementById('taxAmount');
    const totalAmountEl = document.getElementById('totalAmount');
    const clearCartBtn = document.getElementById('clearCartBtn');
    const billBtn = document.getElementById('billBtn');
    const payBtn = document.getElementById('payBtn');
    
    // Cart data stored in memory
    let cart = JSON.parse(localStorage.getItem('posCart')) || {};
    
    // Initialize cart display
    updateCartDisplay();
    
    // Get waiter selection method
    function getWaiterId() {
        <?php if(auth()->user()->is_role == 3): ?>
            return document.getElementById('waiterSelect').value;
        <?php else: ?>
            return document.getElementById('waiterSelect').value;
        <?php endif; ?>
    }
    
    // Frontend-only product search (no backend request)
    const searchInput = document.querySelector('input[name="q"]');
    searchInput.addEventListener('input', function() {
        const query = this.value.trim().toLowerCase();
        
        // Select all product cards inside all tabs
        const productCards = document.querySelectorAll('.product-card');
        
        productCards.forEach(card => {
            const productName = card.querySelector('.card-title').textContent.toLowerCase();
            if (productName.includes(query)) {
                card.closest('.product-item').style.display = '';
            } else {
                card.closest('.product-item').style.display = 'none';
            }
        });

        // Hide empty alphabet sections
        document.querySelectorAll('.alphabet-section').forEach(section => {
            const visible = section.querySelectorAll('.product-item:not([style*="display: none"])').length > 0;
            section.style.display = visible ? '' : 'none';
        });
    });

    
    // Add product to cart when card is clicked
    document.addEventListener('click', function(e) {
        const productCard = e.target.closest('.product-card');
        if (productCard) {
            const productId = productCard.dataset.productId;
            const productName = productCard.querySelector('.card-title').textContent.trim();
            const productPrice = parseFloat(productCard.querySelector('.card-text').textContent.replace('Tsh ', '').replace(/,/g, ''));
            
            addToCart(productId, productName, productPrice);
            
            // Add visual feedback
            productCard.style.transform = 'scale(0.95)';
            setTimeout(() => {
                productCard.style.transform = 'scale(1)';
            }, 150);
        }
    });
    
    // Cart quantity controls
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('increase-qty')) {
            const row = e.target.closest('tr');
            const productId = row.dataset.productId;
            updateCartQuantity(productId, 'increase');
        }
        
        if (e.target.classList.contains('decrease-qty')) {
            const row = e.target.closest('tr');
            const productId = row.dataset.productId;
            updateCartQuantity(productId, 'decrease');
        }
        
        if (e.target.classList.contains('remove-item')) {
            const row = e.target.closest('tr');
            const productId = row.dataset.productId;
            removeFromCart(productId);
        }
    });
    
    // Clear cart modal
    clearCartBtn.addEventListener('click', function() {
        let modal = new bootstrap.Modal(document.getElementById('clearCartModal'));
        modal.show();
    });

    // Handle confirmation button
    document.getElementById('confirmClearCart').addEventListener('click', function() {
        clearCart();
        let modalElement = document.getElementById('clearCartModal');
        let modal = bootstrap.Modal.getInstance(modalElement);
        modal.hide();
    });
    
    // Process payment
    billBtn.addEventListener('click', function() {
        showReceiptPreview('bill');
    });

    payBtn.addEventListener('click', function() {
        const isWaiter = <?php echo e(auth()->user()->is_role == 3 ? 'true' : 'false'); ?>;
        if (isWaiter) {
            showToast('You are not allowed to pay, contact cashier', 'error');
            return;
        }
        showReceiptPreview('pay');
    });
 
    // Frontend Cart Functions (No AJAX calls)
    function addToCart(productId, productName, sellingPrice) {
        if (cart[productId]) {
            cart[productId].quantity += 1;
        } else {
            cart[productId] = {
                id: productId,
                name: productName,
                selling_price: sellingPrice,
                quantity: 1
            };
        }
        
        saveCartToStorage();
        updateCartDisplay();
        showToast('Product added to cart', 'success');
    }
    
    function updateCartQuantity(productId, action) {
        if (!cart[productId]) return;
        
        if (action === 'increase') {
            cart[productId].quantity += 1;
        } else if (action === 'decrease') {
            if (cart[productId].quantity > 1) {
                cart[productId].quantity -= 1;
            } else {
                removeFromCart(productId);
                return;
            }
        }
        
        saveCartToStorage();
        updateCartDisplay();
    }
    
    function removeFromCart(productId) {
        if (cart[productId]) {
            delete cart[productId];
            saveCartToStorage();
            updateCartDisplay();
            showToast('Product removed from cart', 'success');
        }
    }
    
    function clearCart() {
        cart = {};
        saveCartToStorage();
        updateCartDisplay();
        showToast('Cart cleared successfully', 'success');
    }
    
    function saveCartToStorage() {
        localStorage.setItem('posCart', JSON.stringify(cart));
    }

    let saleConfirmed = false;

    function showReceiptPreview(type) {
        if (Object.keys(cart).length === 0) {
            showToast('Cart is empty', 'error');
            return;
        }

        // Check if waiter is selected
        const waiterId = getWaiterId();
        if (!waiterId) {
            showToast('Please select a waiter before processing the order', 'error');
            return;
        }

        let html = `
            <div class="text-center mb-3">
                <div class="receipt-header text-center mb-3">
                    <h6 class="fw-bold mb-1">D RESTAURANT</h6>
                    <p class="small mb-1">Email: dietcateringservices@gmail.com</p>
                    <p class="small mb-1">Viwandani, Dodoma</p>
                    <p class="small mb-2">Phone: 0716780595</p>
                </div>
                <small class="text-muted">Date: ${new Date().toLocaleString()}</small><br>
                <small class="text-muted">Type: ${type === 'pay' ? 'Payment' : 'Bill Preview'}</small>
            </div>
            <table class="table table-sm table-borderless">
                <thead>
                    <tr class="border-bottom">
                        <th class="small fw-semibold">Item</th>
                        <th class="text-center small fw-semibold">Qty × Price</th>
                        <th class="text-end small fw-semibold">Total</th>
                    </tr>
                </thead>
                <tbody>
        `;

        let total = 0;
        Object.values(cart).forEach(item => {
            const lineTotal = item.selling_price * item.quantity;
            total += lineTotal;

            html += `
                <tr class="border-bottom">
                    <td class="small">${item.name}</td>
                    <td class="text-center small">${item.quantity} × ${item.selling_price.toLocaleString()}</td>
                    <td class="text-end small">Tsh ${lineTotal.toLocaleString()}</td>
                </tr>
            `;
        });

        const subtotal = total * 0.82;
        const vat = total * 0.18;

        html += `
                </tbody>
            </table>
            <div class="border-top pt-2">
                <div class="d-flex justify-content-between small"><span>Subtotal:</span><span>Tsh ${subtotal.toLocaleString()}</span></div>
                <div class="d-flex justify-content-between small"><span>VAT (18%):</span><span>Tsh ${vat.toLocaleString()}</span></div>
                <div class="d-flex justify-content-between fw-bold border-top pt-2"><span>Total:</span><span>Tsh ${total.toLocaleString()}</span></div>
            </div>
        `;

        document.getElementById('receiptContent').innerHTML = html;
        document.getElementById('receiptModal').setAttribute('data-type', type);
        const receiptModal = new bootstrap.Modal(document.getElementById('receiptModal'));
        receiptModal.show();
    }

    // Confirm & Print - Only this makes server call
    document.getElementById('confirmPrintReceiptBtn').addEventListener('click', function() {
        saleConfirmed = true;

        const type = document.getElementById('receiptModal').getAttribute('data-type');
        const waiterId = getWaiterId();
        const isWaiter = <?php echo e(auth()->user()->is_role == 3 ? 'true' : 'false'); ?>;
        const paymentMethod = document.getElementById('paymentMethod').value;

        if (!waiterId) {
            showToast('Please select a waiter before processing the order', 'error');
            return;
        }

        // Hide modal first
        const receiptModalEl = document.getElementById('receiptModal');
        const receiptModalInstance = bootstrap.Modal.getInstance(receiptModalEl);
        receiptModalInstance.hide();

        // Prepare cart data for server
        const cartData = Object.values(cart).map(item => ({
            id: item.id,
            name: item.name,
            selling_price: item.selling_price,
            quantity: item.quantity
        }));

        fetch('<?php echo e(route("sales.store")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                waiter_id: waiterId,
                payment_type: paymentMethod,
                sale_type: type,
                cart_items: cartData // Send all cart items at once
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                // Clear local storage and cart
                cart = {};
                localStorage.removeItem('posCart');
                updateCartDisplay();
                showToast(type === 'pay' ? 'Payment confirmed!' : 'Bill created successfully!', 'success');

                // Open receipt in new tab
                const printWindow = window.open(`/sales/receipt/${data.sale_id}`, '_blank');
                if (printWindow) {
                    setTimeout(() => {
                        printWindow.focus();  
                    }, 100);
                } else {
                    showToast('Please allow popups to print receipt.', 'error');
                }
            } else {
                showToast(data.message || 'Error saving sale', 'error');
            }
        })
        .catch(err => {
            console.error(err);
            showToast('Error confirming sale', 'error');
        });
    });

    // Cancel: only toast on modal hidden if not confirmed
    document.getElementById('receiptModal').addEventListener('hidden.bs.modal', function () {
        if (!saleConfirmed) {
            showToast('Bill / payment canceled', 'error');
        }
        saleConfirmed = false; // reset for next time
    });

    function updateCartDisplay() {
        // Helper to capitalize each word
        function ucwords(str) {
            return str.replace(/\b\w/g, c => c.toUpperCase());
        }

        // Helper to format numbers
        function formatNumber(num) {
            return Number(num).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
        }

        // Update cart items
        cartItems.innerHTML = '';

        if (Object.keys(cart).length === 0) {
            cartItems.innerHTML = `
                <tr id="emptyCart">
                    <td colspan="4" class="text-center text-muted py-4">
                        <i class="fas fa-shopping-cart fa-2x mb-2 d-block"></i>
                        Your cart is empty
                    </td>
                </tr>
            `;
        } else {
            for (const [productId, item] of Object.entries(cart)) {
                const row = document.createElement('tr');
                row.dataset.productId = productId;
                row.className = 'border-bottom';

                const priceEach = formatNumber(item.selling_price);
                const totalPrice = formatNumber(item.selling_price * item.quantity);
                const quantity = (item.quantity);

                row.innerHTML = `
                    <td class="py-2">
                        <div class="d-flex align-items-center">
                            <div class="ms-2">
                                <h6 class="mb-0 small fw-semibold">${ucwords(item.name)}</h6>
                                <small class="text-muted">Tsh ${priceEach} each</small>
                            </div>
                        </div>
                    </td>
                    <td class="text-center py-2">
                        <div class="quantity-controls d-flex align-items-center justify-content-center">
                            <button class="btn btn-sm btn-outline-secondary decrease-qty p-1" 
                                    style="width: 28px; height: 28px;" type="button">-</button>
                            <span class="mx-2 quantity-display small fw-semibold">${quantity}</span>
                            <button class="btn btn-sm btn-outline-secondary increase-qty p-1" 
                                    style="width: 28px; height: 28px;" type="button">+</button>
                        </div>
                    </td>
                    <td class="text-end fw-bold py-2 small">Tsh ${totalPrice}</td>
                    <td class="text-end py-2">
                        <button class="btn btn-sm btn-outline-danger remove-item p-1" 
                                style="width: 28px; height: 28px;" type="button">
                            <i class="fas fa-trash fa-xs"></i>
                        </button>
                    </td>
                `;
                cartItems.appendChild(row);
            }
        }

        // Update cart summary
        const total = Object.values(cart).reduce((sum, item) => sum + (item.selling_price * item.quantity), 0);
        const subtotal = total * 0.82;
        const tax = total * 0.18;

        cartCount.textContent = Object.keys(cart).length;
        cartCountBadge.textContent = Object.keys(cart).length;
        subtotalEl.textContent = 'Tsh ' + formatNumber(subtotal);
        taxAmountEl.textContent = 'Tsh ' + formatNumber(tax);
        totalAmountEl.textContent = 'Tsh ' + formatNumber(total);

        // Update button states
        const hasItems = Object.keys(cart).length > 0;
        const isWaiter = <?php echo e(auth()->user()->is_role == 3 ? 'true' : 'false'); ?>;
        clearCartBtn.disabled = !hasItems;
        billBtn.disabled = !hasItems;
        payBtn.disabled = !hasItems;
    }

    // Touch support for mobile devices
document.addEventListener('touchend', function(e) {
    const removeBtn = e.target.closest('.remove-item');
    const increaseBtn = e.target.closest('.increase-qty');
    const decreaseBtn = e.target.closest('.decrease-qty');

    if (removeBtn) {
        e.preventDefault();
        const row = removeBtn.closest('tr');
        const productId = row.dataset.productId;
        removeFromCart(productId);
    }

    if (increaseBtn) {
        e.preventDefault();
        const row = increaseBtn.closest('tr');
        const productId = row.dataset.productId;
        updateCartQuantity(productId, 'increase');
    }

    if (decreaseBtn) {
        e.preventDefault();
        const row = decreaseBtn.closest('tr');
        const productId = row.dataset.productId;
        updateCartQuantity(productId, 'decrease');
    }
});

    
    function showToast(message, type = 'success') {
        const toastHTML = `
            <div class="toast show align-items-center text-bg-${type === 'success' ? 'success' : 'danger'} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body small">
                        <i class="fas fa-${type === 'success' ? 'check' : 'exclamation-triangle'} me-2"></i>
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        const toastContainer = document.querySelector('.toast-container');
        const toastElement = document.createElement('div');
        toastElement.innerHTML = toastHTML;
        toastContainer.appendChild(toastElement);
        
        const toast = new bootstrap.Toast(toastElement.querySelector('.toast'));
        toast.show();
        
        // Remove toast after it's hidden
        toastElement.addEventListener('hidden.bs.toast', function() {
            toastElement.remove();
        });
    }
});
</script>

<style>
.nav-scrollable::-webkit-scrollbar {
    height: 4px;
}
.nav-scrollable::-webkit-scrollbar-track {
    background: #f8f9fa;
}
.nav-scrollable::-webkit-scrollbar-thumb {
    background: #dee2e6;
    border-radius: 2px;
}
.product-card {
    transition: all 0.2s ease;
    cursor: pointer;
}
.product-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important;
}
.cursor-pointer {
    cursor: pointer;
}
.sticky-top {
    position: sticky;
    z-index: 100;
}
.alphabet-grid {
    display: flex;
    flex-wrap: wrap;
    align-items: flex-start;
    gap: 1rem;
}
.alphabet-section {
    display: inline-block;
    vertical-align: top;
}
.alphabet-header {
    margin-bottom: 0.5rem;
}
.products-row {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
}
.product-item {
    flex: 0 0 auto;
}
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }
    .product-card .card-body {
        padding: 0.75rem;
    }
    .alphabet-grid {
        gap: 0.5rem;
    }
    .alphabet-section {
        margin-right: 0.5rem !important;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/sales/list.blade.php ENDPATH**/ ?>