<?php $__env->startSection('title', 'Waiters Payroll - Weekly Summary'); ?>

<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="pb-5">

        <!-- Header and Filters -->
        <div class="mb-4">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="mb-1">Weekly Payroll Summary</h2>
                    <p class="text-body-tertiary">
                        Week <?php echo e($week); ?> of <?php echo e($year); ?>

                        (<?php echo e($weekStart->format('M j')); ?> - <?php echo e($weekEnd->format('M j, Y')); ?>)
                    </p>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <form method="GET" action="<?php echo e(route('payroll.index')); ?>" class="row g-2">
                                <div class="col-md-5">
                                    <label class="form-label small">Year</label>
                                    <select name="year" class="form-select form-select-sm">
                                        <?php $__currentLoopData = $availableYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availableYear): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($availableYear); ?>" <?php echo e($year == $availableYear ? 'selected' : ''); ?>>
                                                <?php echo e($availableYear); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-5">
                                    <label class="form-label small">Week</label>
                                    <select name="week" class="form-select form-select-sm">
                                        <?php for($i = 1; $i <= 52; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e($week == $i ? 'selected' : ''); ?>>
                                                Week <?php echo e($i); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>

                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary btn-sm w-100">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Weekly Summary Table -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card">
                    
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Weekly Payroll Summary</h5>
                        <a href="<?php echo e(route('payroll.export', ['year' => $year, 'week' => $week])); ?>" class="btn btn-sm btn-primary">
                            <i class="fas fa-file-pdf me-1"></i> Export PDF
                        </a>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-body-secondary">
                                    <tr>
                                        <th class="ps-4">#</th>
                                        <th>Waiter Name</th>
                                        <th class="text-center">Total Weekly Sales (TZS)</th>
                                        <th class="text-center">Weekly Payment (TZS)</th>
                                        <th class="text-center">Eligible Days</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $eligibleDays = count(array_filter($waiter['daily'], fn($day) => $day['is_eligible']));
                                    ?>

                                    <tr>
                                        <td class="ps-4"><?php echo e($index + 1); ?></td>

                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if($waiter['avatar']): ?>
                                                    <img src="<?php echo e(asset('storage/' . $waiter['avatar'])); ?>"
                                                         class="rounded-circle me-2" width="32" height="32">
                                                <?php else: ?>
                                                    <div class="bg-secondary text-white rounded-circle me-2 d-flex align-items-center justify-content-center"
                                                         style="width: 32px; height: 32px;">
                                                        <i class="fas fa-user"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <span><?php echo e($waiter['name']); ?></span>
                                            </div>
                                        </td>

                                        <td class="text-center"><?php echo e(number_format($waiter['weekly_total_sales'], 0)); ?></td>

                                        <td class="text-center fw-bold <?php echo e($waiter['weekly_total_payment'] > 0 ? 'text-success' : 'text-muted'); ?>">
                                            <?php if(strtolower($waiter['name']) === 'tumaini george'): ?>
                                                <span class="text-info">Paid Monthly</span>
                                            <?php else: ?>
                                                <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td class="text-center"><?php echo e($eligibleDays); ?></td>
                                        <td class="text-center">
                                            <?php if(strtolower($waiter['name']) === 'tumaini george'): ?>
                                                <span class="badge bg-info">Paid Monthly</span>
                                            <?php elseif($waiter['weekly_total_payment'] > 0): ?>
                                                <span class="badge bg-success">Payable</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">No Payment</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if(count($waiters) == 0): ?>
                                    <tr>
                                        <td colspan="6" class="text-center text-muted py-3">
                                            No waiters found for this week.
                                        </td>
                                    </tr>
                                    <?php endif; ?>

                                </tbody>

                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- Daily Breakdown -->
        <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row mb-5">
            <div class="col-12">
                
                <div class="card">

                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <?php echo e($waiter['name']); ?> - Daily Breakdown
                            <small class="text-muted ms-2">(Week <?php echo e($week); ?>)</small>
                        </h5>
                        <div class="text-end">
                            <small class="text-muted">Weekly Sales: <?php echo e(number_format($waiter['weekly_total_sales'], 0)); ?> TZS</small><br>
                            <small class="text-success fw-bold">Payment: <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?> TZS</small>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">

                            <table class="table table-hover mb-0">
                                <thead class="bg-body-secondary">
                                    <tr>
                                        <th class="ps-4">Day</th>
                                        <th class="text-center">Date</th>
                                        <th class="text-center">Sales Count</th>
                                        <th class="text-center">Total Sales (TZS)</th>
                                        <th class="text-center">4% Value (TZS)</th>
                                        <th class="text-center">Payment (TZS)</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $waiter['daily']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dayData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $fourPercentValue = $dayData['total_amount'] * 0.04;
                                    ?>

                                    <tr>
                                        <td class="ps-4"><strong><?php echo e($dayData['day_name']); ?></strong></td>
                                        <td class="text-center"><?php echo e($dayData['date']); ?></td>
                                        <td class="text-center"><?php echo e($dayData['sales_count']); ?></td>
                                        <td class="text-center"><?php echo e(number_format($dayData['total_amount'], 0)); ?></td>
                                        <td class="text-center"><?php echo e(number_format($fourPercentValue, 0)); ?></td>

                                        <td class="text-center fw-bold <?php echo e($dayData['is_eligible'] ? 'text-success' : 'text-muted'); ?>">
                                            <?php if(strtolower($waiter['name']) === 'tumaini george'): ?>
                                                <span class="text-info">Monthly</span>
                                            <?php else: ?>
                                                <?php echo e(number_format($dayData['payment'], 0)); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td class="text-center">
                                            <span class="badge bg-<?php echo e($dayData['is_eligible'] ? 'success' : 'secondary'); ?>">
                                                <?php echo e($dayData['is_eligible'] ? 'Eligible' : 'Not Eligible'); ?>

                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                                <tfoot class="bg-light">
                                    <tr>
                                        <td colspan="3" class="ps-4"><strong>Weekly Totals</strong></td>

                                        <!-- weekly sales from controller -->
                                        <td class="text-center fw-bold">
                                            <?php echo e(number_format($waiter['weekly_total_sales'], 0)); ?>

                                        </td>

                                        <!-- weekly 4% removed — replaced with dash -->
                                        <td class="text-center fw-bold">-</td>

                                        <!-- weekly payment from controller -->
                                        <td class="text-center fw-bold text-success">
                                            <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                                        </td>

                                        <td></td>
                                    </tr>
                                </tfoot>

                            </table>

                        </div>
                    </div>

                </div>

            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}
.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
}
.table th {
    border-top: none;
    font-weight: 600;
    font-size: 0.875rem;
    text-transform: uppercase;
    color: #6c757d;
}
.badge {
    font-size: 0.75rem;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    if (typeof feather !== 'undefined') {
        feather.replace();
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/admin/payroll/index.blade.php ENDPATH**/ ?>