<?php $__env->startSection('title', 'Stocktaking Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
        <div class="mb-3 mb-md-0">
            <h4 class="fw-bold mb-2">
                <span class="text-muted fw-light">Reports /</span> Stocktaking Report
            </h4>
            <p class="text-body-tertiary mb-0">View and export stocktaking reports</p>
        </div>
        <div class="d-flex flex-wrap gap-2">
            <!-- Filter Buttons -->
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-outline-primary btn-sm active" data-filter-type="day">
                    <i class="fas fa-calendar-day me-2"></i>Day
                </button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-filter-type="week">
                    <i class="fas fa-calendar-week me-2"></i>Week
                </button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-filter-type="month">
                    <i class="fas fa-calendar-alt me-2"></i>Month
                </button>
            </div>
            
            <!-- Date Selectors -->
            <div class="d-flex gap-2">
                <div id="daySelector" class="filter-selector">
                    <input type="date" class="form-control form-control-sm" id="dayDate" value="<?php echo e(date('Y-m-d')); ?>">
                </div>
                <div id="weekSelector" class="filter-selector d-none">
                    <input type="week" class="form-control form-control-sm" id="weekDate" value="<?php echo e(date('Y-\WW')); ?>">
                </div>
                <div id="monthSelector" class="filter-selector d-none">
                    <input type="month" class="form-control form-control-sm" id="monthDate" value="<?php echo e(date('Y-m')); ?>">
                </div>
                
                <button class="btn btn-primary btn-sm" id="applyFilter">
                    <i class="fas fa-filter me-2"></i>Apply
                </button>
            </div>

            <!-- Export Buttons -->
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="fas fa-download me-2"></i>Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item export-btn" href="#" data-format="pdf">PDF</a></li>
                    <li><a class="dropdown-item export-btn" href="#" data-format="excel">Excel</a></li>
                    <li><a class="dropdown-item export-btn" href="#" data-format="csv">CSV</a></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Report Title -->
    <div class="card mb-4">
        <div class="card-body text-center">
            <h4 id="reportTitle" class="mb-0">Stocktaking Report - <?php echo e(date('F d, Y')); ?></h4>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="reportTable">
                    <thead class="bg-body-secondary">
                        <tr>
                            <th width="5%">Sn</th>
                            <th width="20%">Product Name</th>
                            <th width="8%">Date</th>
                            <th width="8%">Opening</th>
                            <th width="8%">Additional</th>
                            <th width="8%">Buying Price</th>
                            <th width="8%">Selling Price</th>
                            <th width="8%">Sold</th>
                            <th width="10%">Amount</th>
                            <th width="10%">Profit</th>
                            <th width="7%">Closed</th>
                        </tr>
                    </thead>
                    <tbody id="reportBody">
                        <!-- Data will be loaded here -->
                    </tbody>
                    <tfoot class="bg-body-secondary fw-bold">
                        <tr>
                            <td colspan="7" class="text-end">TOTALS:</td>
                            <td id="totalSold">0</td>
                            <td id="totalAmount">Tsh 0</td>
                            <td id="totalProfit">Tsh 0</td>
                            <td id="totalClosed">0</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    let currentFilterType = 'day';
    let currentDate = '<?php echo e(date("Y-m-d")); ?>';

    // Initialize
    loadReportData();

    // Filter type buttons
    document.querySelectorAll('[data-filter-type]').forEach(btn => {
        btn.addEventListener('click', function() {
            // Update active button
            document.querySelectorAll('[data-filter-type]').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            currentFilterType = this.getAttribute('data-filter-type');
            
            // Show appropriate date selector
            document.querySelectorAll('.filter-selector').forEach(sel => sel.classList.add('d-none'));
            document.getElementById(currentFilterType + 'Selector').classList.remove('d-none');
        });
    });

    // Apply filter
    document.getElementById('applyFilter').addEventListener('click', loadReportData);

    // Export buttons
    document.querySelectorAll('.export-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const format = this.getAttribute('data-format');
            exportReport(format);
        });
    });

    function loadReportData() {
        // Get date based on current filter type
        switch(currentFilterType) {
            case 'day':
                currentDate = document.getElementById('dayDate').value;
                break;
            case 'week':
                const weekInput = document.getElementById('weekDate').value;
                currentDate = weekInput + '-1'; // Use Monday of the week
                break;
            case 'month':
                currentDate = document.getElementById('monthDate').value + '-01';
                break;
        }

        fetch(`/stocktaking-report/data?type=${currentFilterType}&date=${currentDate}`, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                renderReportTable(data.data);
                document.getElementById('reportTitle').textContent = data.title;
            } else {
                showToast(data.message, 'error');
            }
        })
        .catch(error => {
            console.error('Error loading report data:', error);
            showToast('Error loading report data', 'error');
        });
    }

    function renderReportTable(data) {
        const reportBody = document.getElementById('reportBody');
        reportBody.innerHTML = '';
        
        let totalSold = 0;
        let totalAmount = 0;
        let totalProfit = 0;
        let totalClosed = 0;

        data.forEach((item, index) => {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td class="text-center">${index + 1}</td>
                <td><strong>${item.product_name}</strong></td>
                <td class="text-center">${new Date(item.date).toLocaleDateString()}</td>
                <td class="text-center">${item.opening_stock}</td>
                <td class="text-center">${item.additional_stock}</td>
                <td class="text-end">Tsh ${parseFloat(item.buying_price).toLocaleString()}</td>
                <td class="text-end">Tsh ${parseFloat(item.selling_price).toLocaleString()}</td>
                <td class="text-center">${item.sold_quantity}</td>
                <td class="text-end">Tsh ${parseFloat(item.amount_obtained).toLocaleString()}</td>
                <td class="text-end">Tsh ${parseFloat(item.profit).toLocaleString()}</td>
                <td class="text-center">${item.closed_stock}</td>
            `;
            reportBody.appendChild(row);

            totalSold += parseInt(item.sold_quantity) || 0;
            totalAmount += parseFloat(item.amount_obtained) || 0;
            totalProfit += parseFloat(item.profit) || 0;
            totalClosed += parseInt(item.closed_stock) || 0;
        });

        document.getElementById('totalSold').textContent = totalSold;
        document.getElementById('totalAmount').textContent = `Tsh ${totalAmount.toLocaleString()}`;
        document.getElementById('totalProfit').textContent = `Tsh ${totalProfit.toLocaleString()}`;
        document.getElementById('totalClosed').textContent = totalClosed;
    }

    function exportReport(format) {
        const url = `/stocktaking-report/export?type=${currentFilterType}&date=${currentDate}&format=${format}`;
        window.open(url, '_blank');
    }

    function showToast(message, type = 'success') {
        const toastHTML = `
            <div class="toast show align-items-center text-bg-${type === 'success' ? 'success' : 'danger'} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body small">${message}</div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        const toastContainer = document.querySelector('.toast-container');
        if (!toastContainer) return;
        
        const toastElement = document.createElement('div');
        toastElement.innerHTML = toastHTML;
        toastContainer.appendChild(toastElement);
        
        const toast = new bootstrap.Toast(toastElement.querySelector('.toast'));
        toast.show();
        
        toastElement.addEventListener('hidden.bs.toast', function() {
            toastElement.remove();
        });
    }
});
</script>

<style>
.filter-selector {
    width: 150px;
}

[data-filter-type].active {
    background-color: #0d6efd;
    color: white;
    border-color: #0d6efd;
}

.table td {
    vertical-align: middle;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/stocktaking/report.blade.php ENDPATH**/ ?>