<?php $__env->startSection('title', 'Cashier Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="fw-bold py-3 mb-2">
                <span class="text-muted fw-light">Cashier /</span> Dashboard
            </h4>
        </div>
    </div>

    <!-- Quick Stats Row -->
    <div class="row g-3 mb-4">

        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Breakfast amount Today</h5>
                            <h2 class="mb-0 text-info"><?php echo e(number_format($stats['breakfast_sales'] ?? 0)); ?></h2>
                            <p class="fs-9 mb-0 <?php echo e(($stats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <span class="fas fa-arrow-<?php echo e(($stats['items_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> me-1"></span>
                                <?php echo e(number_format($stats['breakfast_growth'] ?? 0, 1)); ?>% from yesterday
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
        <div class="card-body">
            <div class="d-flex align-items-center">
                <div class="flex-1">
                    <h5 class="mb-1">Verified Sales</h5>
                    <h2 class="mb-0 text-success" id="verified-count"><?php echo e($salesStatus['verified_count'] ?? 0); ?></h2>
                    <p class="fs-9 mb-0"><?php echo e($salesStatus['verified'] ?? 0); ?>% of total</p>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-12 col-sm-6 col-xl-3">
    <div class="card">
        <div class="card-body">
            <div class="d-flex align-items-center">
                <div class="flex-1">
                    <h5 class="mb-1">Unverified Sales</h5>
                    <h2 class="mb-0 text-warning" id="unverified-count"><?php echo e($salesStatus['pending_count'] ?? 0); ?></h2>
                    <p class="fs-9 mb-0"><?php echo e($salesStatus['pending'] ?? 0); ?>% of total</p>
                </div>
            </div>
        </div>
    </div>
</div>

        <div class="col-12 col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-1">
                            <h5 class="mb-1">Total Transactions</h5>
                            <h2 class="mb-0 text-success"><?php echo e($stats['today_sales_count'] ?? 0); ?></h2>
                            <p class="fs-9 mb-0">Today's count</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row g-4 mb-4">
        <!-- Today vs Yesterday Chart -->
        <div class="col-12 col-xxl-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Today vs Yesterday Sales</h5>
                    <small class="text-body-tertiary">Hourly comparison (7:00 - 22:00)</small>
                </div>
                <div class="card-body">
                    <div class="echart-today-yesterday" style="height: 350px;"></div>
                </div>
            </div>
        </div>

        <!-- Sales Status Chart -->
        <div class="col-12 col-xxl-4">
            <div class="card h-100">
                <div class="card-body d-flex flex-column">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="mb-0">Sales Status</h5>
                            <h6 class="text-body-tertiary mb-1">Pending vs Verified</h6>
                        </div>
                    </div>
                    <div class="d-flex justify-content-center pt-1 flex-1">
                        <div class="echarts-sales-status-chart" style="height:250px;width:100%;"></div>
                    </div>
                    <div class="mt-0">
                        <div class="d-flex align-items-center mb-2">
                            <div class="bullet-item bg-success me-2"></div>
                            <h6 class="text-body fw-semibold flex-1 mb-0">Verified Sales</h6>
                            <h6 class="text-body fw-semibold mb-0" id="verified-percentage"><?php echo e($salesStatus['verified'] ?? 0); ?>%</h6>
                        </div>
                        <div class="d-flex align-items-center">
                            <div class="bullet-item bg-warning me-2"></div>
                            <h6 class="text-body fw-semibold flex-1 mb-0">Pending Sales</h6>
                            <h6 class="text-body fw-semibold mb-0" id="pending-percentage"><?php echo e($salesStatus['pending'] ?? 0); ?>%</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Current Time Period Charts -->
    <div class="container">
      <!-- Left Column: Main Comparison Charts -->
      <div class="col-12 col-xxl-12">
      <!-- Quick Stats: Pending Sales by Waiter -->
<?php if(isset($waiterStats) && $waiterStats->count() > 0): ?>
<div class="card mb-4">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h5 class="mb-0">Pending Sales Summary by Waiter</h5>
    <small class="text-muted">Overview of all pending sales totals</small>
  </div>
  <div class="card-body">
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle mb-0">
        <thead>
          <tr>
            <th>Waiter Name</th>
            <th class="text-end">Total Pending Amount (TZS)</th>
            <th class="text-center">Pending Sales Count</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $waiterStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td>
              <span class="fw-semibold text-body">
                <?php echo e($stat->waiter->name ?? 'Walk-in Customer'); ?>

              </span>
            </td>
            <td class="text-end text-primary fw-semibold">
              <?php echo e(number_format($stat->pending_total, 2)); ?>

            </td>
            <td class="text-center text-warning fw-bold">
              <?php echo e($stat->pending_count); ?>

            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php endif; ?>
    <!-- Sales Table -->
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis pt-7 border-y mt-6">
      <div data-list='{"valueNames":["product","customer","rating","review","time"],"page":6}'>
        <div class="row align-items-end justify-content-between pb-5 g-3">
          <div class="col-auto">
            <h3>Pending Transaction</h3>
            <p class="text-body-tertiary lh-sm mb-0">All Pending transactions that require action</p>
          </div>
          <div class="col-12 col-md-auto">
            <div class="row g-2 gy-3">
              <div class="col-auto flex-1">
                <div class="search-box">
                  <form class="position-relative">
                    <input class="form-control search-input search form-control-sm" type="search" placeholder="Search pending sales..." aria-label="Search" />
                    <span class="fas fa-search search-box-icon"></span>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="table-responsive mx-n1 px-1 scrollbar">
          <table class="table fs-9 mb-0 border-top border-translucent">
            <thead>
              <tr>
                <th class="white-space-nowrap fs-9 ps-0 align-middle">
                  <div class="form-check mb-0 fs-8">
                    <input class="form-check-input" id="checkbox-bulk-sales-select" type="checkbox" data-bulk-select='{"body":"table-latest-sales-body"}' />
                  </div>
                </th>
                <th class="sort white-space-nowrap align-middle" scope="col" data-sort="id">ID</th>
                <th class="sort align-middle" scope="col" data-sort="customer" style="min-width:200px;">CUSTOMER/Waiter</th>
                <th class="sort align-middle" scope="col" data-sort="cashier" style="min-width:150px;">CASHIER</th>
                <th class="sort align-middle" scope="col" data-sort="amount" style="min-width:120px;">AMOUNT</th>
                <th class="sort align-middle" scope="col" data-sort="payment" style="min-width:130px;">PAYMENT</th>
                <th class="sort align-middle" scope="col" style="max-width:200px;" data-sort="items">ITEMS</th>
                <th class="sort text-start ps-5 align-middle" scope="col" data-sort="status">STATUS</th>
                <th class="sort text-end align-middle" scope="col" data-sort="time">TIME</th>
                <th class="sort text-end pe-0 align-middle" scope="col">ACTIONS</th>
              </tr>
            </thead>
            <tbody class="list" id="table-latest-sales-body">
              <?php $__currentLoopData = $sales->where('status', 'pending'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr class="hover-actions-trigger btn-reveal-trigger position-static">
                <td class="fs-9 align-middle ps-0">
                  <div class="form-check mb-0 fs-8">
                    <input class="form-check-input" type="checkbox" data-bulk-select-row='{"id":"<?php echo e($sale->id); ?>","customer":"<?php echo e($sale->waiter->name ?? 'N/A'); ?>","amount":"<?php echo e(number_format($sale->total, 2)); ?>","status":"<?php echo e($sale->status); ?>","time":"<?php echo e($sale->created_at->diffForHumans()); ?>"}' />
                  </div>
                </td>
                <td class="align-middle id white-space-nowrap">
                  <h6 class="mb-0 text-body-highlight">#<?php echo e($sale->id); ?></h6>
                </td>
                <td class="align-middle customer white-space-nowrap">
                  <a class="d-flex align-items-center text-body" href="#!">
                    <div class="avatar avatar-l">
                      <?php if($sale->waiter && $sale->waiter->avatar): ?>
                        <img class="rounded-circle" src="<?php echo e(asset($sale->waiter->avatar)); ?>" alt="" />
                      <?php else: ?>
                        <div class="avatar-name rounded-circle">
                          <span><?php echo e(substr($sale->waiter->name ?? 'N', 0, 1)); ?></span>
                        </div>
                      <?php endif; ?>
                    </div>
                    <h6 class="mb-0 ms-3 text-body"><?php echo e($sale->waiter->name ?? 'Walk-in Customer'); ?></h6>
                  </a>
                </td>
                <td class="align-middle cashier white-space-nowrap">
                  <span class="text-body"><?php echo e($sale->cashier->name ?? 'System'); ?></span>
                </td>
                <td class="align-middle amount white-space-nowrap">
                  <h6 class="mb-0 text-body-highlight">Tsh. <?php echo e(number_format($sale->total, 2)); ?></h6>
                </td>
                <td class="align-middle payment white-space-nowrap">
                  <span class="badge fs-10 badge-phoenix 
                    <?php if($sale->payment_type === 'Cash'): ?> badge-phoenix-primary
                    <?php elseif($sale->payment_type === 'Mobile'): ?> badge-phoenix-info
                    <?php else: ?> badge-phoenix-secondary <?php endif; ?>">
                    <span class="badge-label"><?php echo e($sale->payment_type); ?></span>
                  </span>
                </td>
                <td class="align-middle items" style="min-width:200px;">
                  <p class="fs-9 fw-semibold text-body-highlight mb-0">
                    <?php echo e($sale->items->count()); ?> items
                    <?php if($sale->items->count() > 0): ?>
                    <br><small class="text-muted"><?php echo e($sale->items->first()->product->name ?? ''); ?><?php echo e($sale->items->count() > 1 ? ' +' . ($sale->items->count() - 1) . ' more' : ''); ?></small>
                    <?php endif; ?>
                  </p>
                </td>
                <td class="align-middle text-start ps-5 status">
                  <?php if($sale->status === 'verified'): ?>
                    <span class="badge badge-phoenix fs-10 badge-phoenix-success">
                      <span class="badge-label">Verified</span>
                      <span class="ms-1" data-feather="check" style="height:12.8px;width:12.8px;"></span>
                    </span>
                  <?php else: ?>
                    <span class="badge badge-phoenix fs-10 badge-phoenix-warning">
                      <span class="badge-label">Pending</span>
                      <span class="ms-1" data-feather="clock" style="height:12.8px;width:12.8px;"></span>
                    </span>
                  <?php endif; ?>
                </td>
                <td class="align-middle text-end time white-space-nowrap">
                  <div>
                    <h6 class="text-body-highlight mb-0"><?php echo e($sale->created_at->format('H:i')); ?></h6>
                    <small class="text-muted"><?php echo e($sale->created_at->format('M d, Y')); ?></small>
                  </div>
                </td>
                <td class="align-middle text-center">
                  <div class="d-flex justify-content-center gap-2">
                    <?php if($sale->status === 'pending'): ?>
                      <button class="btn btn-sm btn-phoenix-success verify-sale" 
                              data-sale-id="<?php echo e($sale->id); ?>"
                              data-sale-amount="Tsh. <?php echo e(number_format($sale->total)); ?>"
                              data-sale-customer="<?php echo e($sale->waiter->name ?? 'Walk-in Customer'); ?>"
                              title="Verify sale">
                        <span class="fas fa-check fs-10"></span>
                      </button>
                    <?php endif; ?>
                    <a href="<?php echo e(url('sales/receipt/'.$sale->id)); ?>" 
                       class="btn btn-sm btn-phoenix-primary"
                       target="_blank"
                       title="View Receipt">
                      <span class="fas fa-eye fs-10"></span>
                    </a>
                  </div>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
        <div class="row align-items-center py-1">
          <div class="pagination d-none"></div>
          <div class="col d-flex fs-9">
            <p class="mb-0 d-none d-sm-block me-3 fw-semibold text-body" data-list-info="data-list-info"></p>
            <a class="fw-semibold" href="#!" data-list-view="*">View all<span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span></a>
            <a class="fw-semibold d-none" href="#!" data-list-view="less">View Less</a>
          </div>
          <div class="col-auto d-flex">
            <button class="btn btn-link px-1 me-1" type="button" title="Previous" data-list-pagination="prev">
              <span class="fas fa-chevron-left me-2"></span>Previous
            </button>
            <button class="btn btn-link px-1 ms-1" type="button" title="Next" data-list-pagination="next">
              Next<span class="fas fa-chevron-right ms-2"></span>
            </button>
          </div>
        </div>
      </div>
    </div>
</div>
</div>
</div>

<!-- Verification Confirmation Modal -->
<div class="modal fade" id="verifyModal" tabindex="-1" aria-labelledby="verifyModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="verifyModalLabel">Verify Sale</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Are you sure you want to verify this sale?</p>
        <div class="sale-details mt-3 p-3 bg-light rounded">
          <p class="mb-1"><strong>Waiter:</strong> <span id="modal-customer-name"></span></p>
          <p class="mb-1"><strong>Amount:</strong> <span id="modal-sale-amount"></span></p>
          <p class="mb-0"><strong>Receipt ID:</strong> #<span id="modal-sale-id"></span></p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-success" id="confirm-verify">Verify Sale</button>
      </div>
    </div>
  </div>
</div>

<!-- Toast container -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Pass PHP data to JavaScript
window.chartData = <?php echo json_encode($chartData ?? [], 15, 512) ?>;
window.salesStatus = <?php echo json_encode($salesStatus ?? [], 15, 512) ?>;
window.salesData = <?php echo json_encode($sales ?? [], 15, 512) ?>;

document.addEventListener("DOMContentLoaded", function() {
    // Initialize charts
    initializeCharts();
    
    // Search functionality
    const searchInput = document.querySelector('.search-input');
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const rows = document.querySelectorAll('#table-latest-sales-body tr');
            
            rows.forEach(row => {
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            });
        });
    }

    // Variables for verification modal
    let currentSaleId = null;
    let currentVerifyButton = null;
    
    // Verify sale modal trigger
    document.addEventListener('click', function(e) {
        const button = e.target.closest('.verify-sale');
        if (!button) return;
        
        e.preventDefault();
        currentSaleId = button.getAttribute('data-sale-id');
        currentVerifyButton = button;
        
        // Populate modal with sale details
        document.getElementById('modal-sale-id').textContent = currentSaleId;
        document.getElementById('modal-customer-name').textContent = button.getAttribute('data-sale-customer');
        document.getElementById('modal-sale-amount').textContent = button.getAttribute('data-sale-amount');
        
        // Show the modal
        const verifyModal = new bootstrap.Modal(document.getElementById('verifyModal'));
        verifyModal.show();
    });
    
    // Confirm verification
    document.getElementById('confirm-verify').addEventListener('click', function() {
        if (!currentSaleId) return;
        
        // Close the modal
        const verifyModal = bootstrap.Modal.getInstance(document.getElementById('verifyModal'));
        verifyModal.hide();
        
        // Send verification request
        fetch(`/sales/${currentSaleId}/verify`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            },
            body: JSON.stringify({})
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showToast('Sale verified successfully!', 'success');

                // Update status badge
                const statusBadge = currentVerifyButton.closest('tr').querySelector('.status');
                statusBadge.innerHTML = `
                    <span class="badge badge-phoenix fs-10 badge-phoenix-success">
                        <span class="badge-label">Verified</span>
                        <span class="ms-1" data-feather="check" style="height:12.8px;width:12.8px;"></span>
                    </span>
                `;

                // Hide the clicked button
                currentVerifyButton.style.display = 'none';

                // Update pending count in stats
                updatePendingCount();

                // Refresh Feather icons
                if (typeof feather !== 'undefined') feather.replace();
            } else {
                showToast('Error verifying sale: ' + data.message, 'danger');
            }
        })
        .catch(error => {
            showToast('Error verifying sale: ' + error.message, 'danger');
            console.error('Error:', error);
        });
    });

    // Toast helper function
    function showToast(message, type = 'success') {
        // Remove existing toasts
        const existingToasts = document.querySelectorAll('.toast');
        existingToasts.forEach(toast => toast.remove());

        const toastHTML = `
            <div class="toast align-items-center text-bg-${type} border-0 show" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        const toastContainer = document.querySelector('.toast-container');
        if (toastContainer) {
            toastContainer.innerHTML = toastHTML;
            const toastElement = toastContainer.querySelector('.toast');
            const toast = new bootstrap.Toast(toastElement, { delay: 4000 });
            toast.show();
        }
    }

    // Update pending count after verification
function updatePendingCount() {
    const pendingCountElement = document.getElementById('unverified-count');
    if (pendingCountElement) {
        let currentCount = parseInt(pendingCountElement.textContent) || 0;
        if (currentCount > 0) {
            pendingCountElement.textContent = currentCount - 1;
        }
    }

    // also update percentages if needed
    const pendingPercentageEl = document.getElementById('pending-percentage');
    const verifiedPercentageEl = document.getElementById('verified-percentage');
    if (pendingPercentageEl && verifiedPercentageEl) {
        let pending = parseInt(pendingPercentageEl.textContent) || 0;
        let verified = parseInt(verifiedPercentageEl.textContent) || 0;

        if (pending > 0) {
            pendingPercentageEl.textContent = (pending - 1) + '%';
            verifiedPercentageEl.textContent = (verified + 1) + '%';
        }
    }
}


    // Initialize Feather icons (if used)
    if (typeof feather !== 'undefined') {
        feather.replace();
    }

});

function initializeCharts() {
    // Today vs Yesterday Chart - Non-smooth lines
    if (window.chartData.today_vs_yesterday && window.echarts) {
        const chartEl = document.querySelector('.echart-today-yesterday');
        if (chartEl) {
            const chart = echarts.init(chartEl);
            const option = {
                color: ['#007bff', '#6c757d'],
                tooltip: {
                    trigger: 'axis',
                    formatter: function(params) {
                        return `<strong>${params[0].name}</strong><br/>
                                ${params[0].seriesName}: <span style="color: #007bff; font-weight: bold;">Tsh ${params[0].value.toLocaleString()}</span><br/>
                                ${params[1].seriesName}: <span style="color: #6c757d; font-weight: bold;">Tsh ${params[1].value.toLocaleString()}</span>`;
                    }
                },
                legend: {
                    data: ['Today', 'Yesterday'],
                    top: 10
                },
                grid: {
                    left: '3%',
                    right: '4%',
                    bottom: '3%',
                    containLabel: true
                },
                xAxis: {
                    type: 'category',
                    data: window.chartData.today_vs_yesterday.labels
                },
                yAxis: {
                    type: 'value',
                    axisLabel: {
                        formatter: 'Tsh {value}'
                    }
                },
                series: [
                    {
                        name: 'Today',
                        type: 'line',
                        data: window.chartData.today_vs_yesterday.today_sales,
                        smooth: false, // Non-smooth lines
                        lineStyle: {
                            width: 1
                        },
                        itemStyle: {
                            color: '#007bff'
                        }
                    },
                    {
                        name: 'Yesterday',
                        type: 'line',
                        data: window.chartData.today_vs_yesterday.yesterday_sales,
                        smooth: false, // Non-smooth lines
                        lineStyle: {
                            width: 1,
                            type: 'dashed'
                        },
                        itemStyle: {
                            color: '#f10707ff'
                        }
                    }
                ]
            };
            chart.setOption(option);
        }
    }

    // Sales Status Chart
    const salesStatusEl = document.querySelector('.echarts-sales-status-chart');
    if (salesStatusEl && window.echarts) {
        const chart = echarts.init(salesStatusEl);
        const verified = window.salesStatus.verified || 0;
        const pending = window.salesStatus.pending || 0;
        
        const option = {
            tooltip: {
                trigger: 'item',
                formatter: '{a} <br/>{b}: {c} ({d}%)'
            },
            legend: {
                show: false
            },
            series: [{
                name: 'Sales Status',
                type: 'pie',
                radius: ['65%', '80%'],
                avoidLabelOverlap: false,
                itemStyle: {
                    borderRadius: 6,
                    borderColor: '#fff',
                    borderWidth: 2
                },
                label: {
                    show: false
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '14',
                        fontWeight: 'bold',
                        formatter: '{b}\n{c}%'
                    }
                },
                labelLine: {
                    show: false
                },
                data: [
                    {
                        value: verified,
                        name: 'Verified',
                        itemStyle: {
                            color: '#28a745'
                        }
                    },
                    {
                        value: pending,
                        name: 'Pending',
                        itemStyle: {
                            color: '#ffc107'
                        }
                    }
                ]
            }]
        };
        chart.setOption(option);
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/dashboard/cashier_list.blade.php ENDPATH**/ ?>