(function (factory) {
  typeof define === 'function' && define.amd ? define(factory) :
  factory();
})((function () { 'use strict';

  const getColor=(e,t=document.documentElement)=>getComputedStyle(t).getPropertyValue(`--phoenix-${e}`).trim();

  const mapboxClusterInit=()=>{const e=document.querySelectorAll("#mapbox-cluster");e&&e.forEach((()=>{window.mapboxgl.accessToken="pk.eyJ1IjoidGhlbWV3YWdvbiIsImEiOiJjbGhmNW5ybzkxcmoxM2RvN2RmbW1nZW90In0.hGIvQ890TYkZ948MVrsMIQ";const e=new window.mapboxgl.Map({container:"mapbox-cluster",style:{default:"mapbox://styles/mapbox/light-v11",light:"mapbox://styles/themewagon/clj57pads001701qo25756jtw",dark:"mapbox://styles/themewagon/cljzg9juf007x01pk1bepfgew"}[window.config.config.phoenixTheme],center:[-73.102712,7.102257],zoom:3.5,pitch:40,attributionControl:!1});e.on("load",(()=>{e.addSource("earthquakes",{type:"geojson",data:"https://docs.mapbox.com/mapbox-gl-js/assets/earthquakes.geojson",cluster:!0,clusterMaxZoom:14,clusterRadius:50}),e.addLayer({id:"clusters",type:"circle",source:"earthquakes",filter:["has","point_count"],paint:{"circle-color":["step",["get","point_count"],getColor("secondary"),100,getColor("info"),750,getColor("warning")],"circle-radius":["step",["get","point_count"],20,100,30,750,40]}}),e.addLayer({id:"cluster-count",type:"symbol",source:"earthquakes",filter:["has","point_count"],layout:{"text-field":["get","point_count_abbreviated"],"text-font":["DIN Offc Pro Medium","Arial Unicode MS Bold"],"text-size":12},paint:{"text-color":getColor("white")}}),e.addLayer({id:"unclustered-point",type:"circle",source:"earthquakes",filter:["!",["has","point_count"]],paint:{"circle-color":getColor("primary-light"),"circle-radius":4,"circle-stroke-width":1,"circle-stroke-color":getColor("emphasis-bg")}}),e.on("click","clusters",(t=>{const o=e.queryRenderedFeatures(t.point,{layers:["clusters"]}),r=o[0].properties.cluster_id;e.getSource("earthquakes").getClusterExpansionZoom(r,((t,r)=>{t||e.easeTo({center:o[0].geometry.coordinates,zoom:r});}));})),e.on("click","unclustered-point",(t=>{const o=t.features[0].geometry.coordinates.slice(),{mag:r}=t.features[0].properties,s=1===t.features[0].properties.tsunami?"yes":"no";for(;Math.abs(t.lngLat.lng-o[0])>180;)o[0]+=t.lngLat.lng>o[0]?360:-360;(new window.mapboxgl.Popup).setLngLat(o).setHTML(`magnitude: ${r}<br>Was there a tsunami?: ${s}`).addTo(e);})),e.on("mouseenter","clusters",(()=>{e.getCanvas().style.cursor="pointer";})),e.on("mouseleave","clusters",(()=>{e.getCanvas().style.cursor="";}));}));}));},themeController=document.body;themeController&&themeController.addEventListener("clickControl",(()=>{mapboxClusterInit();}));

  const{merge:merge}=window._;const echartSetOption=(t,e,s,n)=>{const{breakpoints:o,resize:a}=window.phoenix.utils,l=e=>{Object.keys(e).forEach((s=>{window.innerWidth>o[s]&&t.setOption(e[s]);}));},r=document.body;t.setOption(merge(s(),e));const i=document.querySelector(".navbar-vertical-toggle");i&&i.addEventListener("navbar.vertical.toggle",(()=>{t.resize(),n&&l(n);})),a((()=>{t.resize(),n&&l(n);})),n&&l(n),r.addEventListener("clickControl",(({detail:{control:o}})=>{"phoenixTheme"===o&&t.setOption(window._.merge(s(),e)),n&&l(n);}));};const echartTabs=document.querySelectorAll("[data-tab-has-echarts]");echartTabs&&echartTabs.forEach((t=>{t.addEventListener("shown.bs.tab",(t=>{const e=t.target,{hash:s}=e,n=s||e.dataset.bsTarget,o=document.getElementById(n.substring(1))?.querySelector("[data-echart-tab]");o&&window.echarts.init(o).resize();}));}));const handleTooltipPosition=([t,,e,,s])=>{if(window.innerWidth<=540){const n=e.offsetHeight,o={top:t[1]-n-20};return o[t[0]<s.viewSize[0]/2?"left":"right"]=5,o}return null};

  const{echarts:echarts}=window,tripReviewChartInit=()=>{const{getData:t,getColor:o}=window.phoenix.utils,e=document.querySelectorAll(".echart-trip-review");e&&e.forEach((e=>{const i=t(e,"options"),r=echarts.init(e);echartSetOption(r,i,(()=>({tooltip:{trigger:"item",padding:[7,10],backgroundColor:o("body-highlight-bg"),borderColor:o("border-color"),textStyle:{color:o("light-text-emphasis")},borderWidth:1,position:(...t)=>handleTooltipPosition(t),transitionDuration:0,formatter:t=>`<strong>${t.seriesName}:</strong> ${t.value}%`,extraCssText:"z-index: 1000"},series:[{type:"gauge",name:"Commission",startAngle:90,endAngle:-270,radius:"90%",pointer:{show:!1},progress:{show:!0,overlap:!1,clip:!1,itemStyle:{color:o("primary")}},axisLine:{lineStyle:{width:4,color:[[1,o("secondary-bg")]]}},splitLine:{show:!1},axisTick:{show:!1},axisLabel:{show:!1},detail:{fontSize:"20px",color:o("body-color"),offsetCenter:[0,"10%"]}}]})));}));};

  const{docReady:docReady}=window.phoenix.utils;docReady(tripReviewChartInit),docReady(mapboxClusterInit);

}));
//# sourceMappingURL=trip.js.map
